/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.valuesource.MultiFunction;

public class MinFloatFunction
extends MultiFloatFunction {
    public MinFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "min";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) throws IOException {
        if (!this.exists(doc, valsArr)) {
            return 0.0f;
        }
        float val2 = Float.POSITIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            val2 = Math.min(vals.floatVal(doc), val2);
        }
        return val2;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) throws IOException {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

