/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;

public class SortedSetDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedSetDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive){

            @Override
            SortedSetDocValues getValues(LeafReader reader, String field) throws IOException {
                return DocValues.getSortedSet(reader, field);
            }
        };
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedSetDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        TYPE.freeze();
    }
}

