/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.FutureObjects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.NumericUtils;

public class FloatRange
extends Field {
    public static final int BYTES = 4;

    public FloatRange(String name, float[] min2, float[] max) {
        super(name, FloatRange.getType(min2.length));
        this.setRangeValues(min2, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("FloatRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 4);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(float[] min2, float[] max) {
        byte[] bytes;
        FloatRange.checkArgs(min2, max);
        if (min2.length * 2 != this.type.pointDataDimensionCount() || max.length * 2 != this.type.pointDataDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min2.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[8 * min2.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        FloatRange.verifyAndEncode(min2, max, bytes);
    }

    private static void checkArgs(float[] min2, float[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min2.length > 4) {
            throw new IllegalArgumentException("FloatRange does not support greater than 4 dimensions");
        }
    }

    private static byte[] encode(float[] min2, float[] max) {
        FloatRange.checkArgs(min2, max);
        byte[] b = new byte[8 * min2.length];
        FloatRange.verifyAndEncode(min2, max, b);
        return b;
    }

    static void verifyAndEncode(float[] min2, float[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min2.length * 4;
        while (d < min2.length) {
            if (Double.isNaN(min2[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in FloatRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in FloatRange");
            }
            if (min2[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min2[d] + ") is greater than max value (" + max[d] + ")");
            }
            FloatRange.encode(min2[d], bytes, i);
            FloatRange.encode(max[d], bytes, j);
            ++d;
            i += 4;
            j += 4;
        }
    }

    private static void encode(float val2, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes(NumericUtils.floatToSortableInt(val2), bytes, offset);
    }

    public float getMin(int dimension) {
        FutureObjects.checkIndex(dimension, this.type.pointDataDimensionCount() / 2);
        return FloatRange.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public float getMax(int dimension) {
        FutureObjects.checkIndex(dimension, this.type.pointDataDimensionCount() / 2);
        return FloatRange.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static float decodeMin(byte[] b, int dimension) {
        int offset = dimension * 4;
        return NumericUtils.sortableIntToFloat(NumericUtils.sortableBytesToInt(b, offset));
    }

    static float decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 4;
        return NumericUtils.sortableIntToFloat(NumericUtils.sortableBytesToInt(b, offset));
    }

    public static Query newIntersectsQuery(String field, float[] min2, float[] max) {
        return FloatRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, float[] min2, float[] max) {
        return FloatRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, float[] min2, float[] max) {
        return FloatRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, float[] min2, float[] max) {
        return FloatRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, float[] min2, float[] max, RangeFieldQuery.QueryType relation) {
        FloatRange.checkArgs(min2, max);
        return new RangeFieldQuery(field, FloatRange.encode(min2, max), min2.length, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return FloatRange.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        FloatRange.toString(b, 0);
        for (int d = 0; d < this.type.pointDataDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(FloatRange.toString(b, d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Float.toString(FloatRange.decodeMin(ranges, dimension)) + " : " + Float.toString(FloatRange.decodeMax(ranges, dimension)) + "]";
    }
}

