/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.no;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.util.StemmerUtil;

public class NorwegianLightStemmer {
    public static final int BOKMAAL = 1;
    public static final int NYNORSK = 2;
    final boolean useBokmaal;
    final boolean useNynorsk;

    public NorwegianLightStemmer(int flags) {
        if (flags <= 0 || flags > 3) {
            throw new IllegalArgumentException("invalid flags");
        }
        this.useBokmaal = (flags & 1) != 0;
        this.useNynorsk = (flags & 2) != 0;
    }

    public int stem(char[] s2, int len) {
        if (len > 4 && s2[len - 1] == 's') {
            --len;
        }
        if (len > 7 && (StemmerUtil.endsWith(s2, len, "heter") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "heten") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "heita") && this.useNynorsk)) {
            return len - 5;
        }
        if (len > 8 && this.useNynorsk && (StemmerUtil.endsWith(s2, len, "heiter") || StemmerUtil.endsWith(s2, len, "leiken") || StemmerUtil.endsWith(s2, len, "leikar"))) {
            return len - 6;
        }
        if (len > 5 && (StemmerUtil.endsWith(s2, len, "dom") || StemmerUtil.endsWith(s2, len, "het") && this.useBokmaal)) {
            return len - 3;
        }
        if (len > 6 && this.useNynorsk && (StemmerUtil.endsWith(s2, len, "heit") || StemmerUtil.endsWith(s2, len, "semd") || StemmerUtil.endsWith(s2, len, "leik"))) {
            return len - 4;
        }
        if (len > 7 && (StemmerUtil.endsWith(s2, len, "elser") || StemmerUtil.endsWith(s2, len, "elsen"))) {
            return len - 5;
        }
        if (len > 6 && (StemmerUtil.endsWith(s2, len, "ende") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "ande") && this.useNynorsk || StemmerUtil.endsWith(s2, len, "else") || StemmerUtil.endsWith(s2, len, "este") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "aste") && this.useNynorsk || StemmerUtil.endsWith(s2, len, "eren") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "aren") && this.useNynorsk)) {
            return len - 4;
        }
        if (len > 5 && (StemmerUtil.endsWith(s2, len, "ere") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "are") && this.useNynorsk || StemmerUtil.endsWith(s2, len, "est") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "ast") && this.useNynorsk || StemmerUtil.endsWith(s2, len, "ene") || StemmerUtil.endsWith(s2, len, "ane") && this.useNynorsk)) {
            return len - 3;
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "er") || StemmerUtil.endsWith(s2, len, "en") || StemmerUtil.endsWith(s2, len, "et") || StemmerUtil.endsWith(s2, len, "ar") && this.useNynorsk || StemmerUtil.endsWith(s2, len, "st") && this.useBokmaal || StemmerUtil.endsWith(s2, len, "te"))) {
            return len - 2;
        }
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': 
                case 'n': {
                    return len - 1;
                }
            }
        }
        return len;
    }
}

