/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.AttributeSource;

public class FingerprintFilter
extends TokenFilter {
    public static final int DEFAULT_MAX_OUTPUT_TOKEN_SIZE = 1024;
    public static final char DEFAULT_SEPARATOR = ' ';
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = this.addAttribute(PositionLengthAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private CharArraySet uniqueTerms = null;
    private final int maxOutputTokenSize;
    private AttributeSource.State finalState;
    private final char separator;
    private boolean inputEnded = false;

    public FingerprintFilter(TokenStream input) {
        this(input, 1024, ' ');
    }

    public FingerprintFilter(TokenStream input, int maxOutputTokenSize, char separator) {
        super(input);
        this.maxOutputTokenSize = maxOutputTokenSize;
        this.separator = separator;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.inputEnded) {
            return false;
        }
        boolean result = this.buildSingleOutputToken();
        this.finalState = this.captureState();
        return result;
    }

    private final boolean buildSingleOutputToken() throws IOException {
        this.inputEnded = false;
        char[] clonedLastTerm = null;
        this.uniqueTerms = new CharArraySet(8, false);
        int outputTokenSize = 0;
        while (this.input.incrementToken()) {
            int length;
            char[] term;
            if (outputTokenSize > this.maxOutputTokenSize || this.uniqueTerms.contains(term = this.termAttribute.buffer(), 0, length = this.termAttribute.length())) continue;
            clonedLastTerm = new char[length];
            System.arraycopy(term, 0, clonedLastTerm, 0, length);
            if (this.uniqueTerms.size() > 0) {
                ++outputTokenSize;
            }
            this.uniqueTerms.add(clonedLastTerm);
            outputTokenSize += length;
        }
        this.input.end();
        this.inputEnded = true;
        this.offsetAtt.setOffset(0, this.offsetAtt.endOffset());
        this.posLenAtt.setPositionLength(1);
        this.posIncrAtt.setPositionIncrement(1);
        this.typeAtt.setType("fingerprint");
        if (this.uniqueTerms.size() < 1) {
            this.termAttribute.setEmpty();
            return false;
        }
        if (outputTokenSize > this.maxOutputTokenSize) {
            this.termAttribute.setEmpty();
            this.uniqueTerms.clear();
            return false;
        }
        if (this.uniqueTerms.size() == 1) {
            this.termAttribute.setEmpty().append(new String(clonedLastTerm));
            this.uniqueTerms.clear();
            return true;
        }
        Object[] items = this.uniqueTerms.toArray();
        Arrays.sort(items, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                char[] v1 = (char[])o1;
                char[] v2 = (char[])o2;
                int len1 = v1.length;
                int len2 = v2.length;
                int lim = Math.min(len1, len2);
                for (int k = 0; k < lim; ++k) {
                    char c1 = v1[k];
                    char c2 = v2[k];
                    if (c1 == c2) continue;
                    return c1 - c2;
                }
                return len1 - len2;
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Object item : items) {
            if (sb.length() >= 1) {
                sb.append(this.separator);
            }
            sb.append((char[])item);
        }
        this.termAttribute.setEmpty().append(sb);
        this.uniqueTerms.clear();
        return true;
    }

    @Override
    public final void end() throws IOException {
        if (!this.inputEnded) {
            this.input.end();
            this.inputEnded = true;
        }
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.inputEnded = false;
        this.uniqueTerms = null;
    }
}

