/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.protocol;

import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpRequest;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.annotation.Contract;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.protocol.UriPatternMatcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String pattern, HttpAsyncRequestHandler<?> handler) {
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request) {
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                uriPath = uriPath.substring(0, index);
            }
        }
        return uriPath;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest request) {
        return this.matcher.lookup(this.getRequestPath(request));
    }
}

