/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.ContentTooLongException;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpEntity;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpResponse;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.entity.ContentType;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.ContentDecoder;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.IOControl;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.protocol.HttpContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.util.Asserts;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

