/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCJava;
import org.apache.derby.impl.services.bytecode.BCLocalField;
import org.apache.derby.impl.services.bytecode.BCMethodCaller;
import org.apache.derby.impl.services.bytecode.BCMethodDescriptor;
import org.apache.derby.impl.services.bytecode.CodeChunk;
import org.apache.derby.impl.services.bytecode.Conditional;
import org.apache.derby.impl.services.bytecode.Type;

class BCMethod
implements MethodBuilder {
    static final int CODE_SPLIT_LENGTH = 65535;
    final BCClass cb;
    protected final ClassHolder modClass;
    final String myReturnType;
    private final String myName;
    BCLocalField[] parameters;
    private final String[] parameterTypes;
    Vector<String> thrownExceptions;
    CodeChunk myCode;
    protected ClassMember myEntry;
    private int currentVarNum;
    private int statementNum;
    private boolean handlingOverflow;
    private int subMethodCount;
    private Type[] stackTypes = new Type[8];
    private int stackTypeOffset;
    int maxStack;
    private int stackDepth;
    private Conditional condition;
    private static final byte[] newArrayElementTypeMap = new byte[]{8, 9, 10, 11, 6, 7, 5};
    static final byte T_BOOLEAN = 4;

    BCMethod(ClassBuilder classBuilder, String string, String string2, int n, String[] stringArray, BCJava bCJava) {
        String[] stringArray2;
        this.cb = (BCClass)classBuilder;
        this.modClass = this.cb.modify();
        this.myReturnType = string;
        this.myName = string2;
        if ((n & 8) == 0) {
            this.currentVarNum = 1;
        }
        if (stringArray != null && stringArray.length != 0) {
            int n2 = stringArray.length;
            stringArray2 = new String[n2];
            this.parameters = new BCLocalField[n2];
            for (int i = 0; i < n2; ++i) {
                Type type = bCJava.type(stringArray[i]);
                this.parameters[i] = new BCLocalField(type, this.currentVarNum);
                this.currentVarNum += type.width();
                stringArray2[i] = type.vmName();
            }
        } else {
            stringArray2 = BCMethodDescriptor.EMPTY;
        }
        String string3 = BCMethodDescriptor.get(stringArray2, bCJava.type(string).vmName(), bCJava);
        this.myEntry = this.modClass.addMember(string2, string3, n);
        this.myCode = new CodeChunk(this.cb);
        this.parameterTypes = stringArray;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void getParameter(int n) {
        int n2 = this.parameters[n].cpi;
        short s2 = this.parameters[n].type.vmType();
        if (n2 < 4) {
            this.myCode.addInstr((short)(CodeChunk.LOAD_VARIABLE_FAST[s2] + n2));
        } else {
            this.myCode.addInstrWide(CodeChunk.LOAD_VARIABLE[s2], n2);
        }
        this.growStack(this.parameters[n].type);
    }

    @Override
    public void addThrownException(String string) {
        if (this.thrownExceptions == null) {
            this.thrownExceptions = new Vector();
        }
        this.thrownExceptions.add(string);
    }

    @Override
    public void complete() {
        if (this.myCode.getPC() > 65535) {
            this.splitMethod();
        }
        this.writeExceptions();
        this.myCode.complete(this, this.modClass, this.myEntry, this.maxStack, this.currentVarNum);
    }

    private void splitMethod() {
        int n = 0;
        boolean bl = true;
        int n2 = this.myCode.getPC();
        while (this.cb.limitMsg == null && n2 > 65535) {
            int n3;
            int n4 = n2 < 131070 ? n2 - 65535 : 65534;
            if (n4 > (n3 = n2 - n)) {
                n4 = n3;
            }
            if ((n = bl ? this.myCode.splitZeroStack(this, this.modClass, n, n4) : this.myCode.splitExpressionOut(this, this.modClass, n4, this.maxStack)) < 0) {
                if (!bl) break;
                bl = false;
                n = 0;
            }
            n2 = this.myCode.getPC();
        }
    }

    ClassHolder constantPool() {
        return this.modClass;
    }

    protected void writeExceptions() {
        if (this.thrownExceptions == null) {
            return;
        }
        int n = this.thrownExceptions.size();
        if (n != 0) {
            try {
                ClassFormatOutput classFormatOutput = new ClassFormatOutput(n * 2 + 2);
                classFormatOutput.putU2(n);
                for (int i = 0; i < n; ++i) {
                    String string = this.thrownExceptions.get(i).toString();
                    int n2 = this.modClass.addClassReference(string);
                    classFormatOutput.putU2(n2);
                }
                this.myEntry.addAttribute("Exceptions", classFormatOutput);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void growStack(int n, Type type) {
        this.stackDepth += n;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
        if (this.stackTypeOffset >= this.stackTypes.length) {
            Type[] typeArray = new Type[this.stackTypes.length + 8];
            System.arraycopy(this.stackTypes, 0, typeArray, 0, this.stackTypes.length);
            this.stackTypes = typeArray;
        }
        this.stackTypes[this.stackTypeOffset++] = type;
    }

    private void growStack(Type type) {
        this.growStack(type.width(), type);
    }

    private Type popStack() {
        --this.stackTypeOffset;
        Type type = this.stackTypes[this.stackTypeOffset];
        this.stackDepth -= type.width();
        return type;
    }

    private Type[] copyStack() {
        Type[] typeArray = new Type[this.stackTypeOffset];
        System.arraycopy(this.stackTypes, 0, typeArray, 0, this.stackTypeOffset);
        return typeArray;
    }

    @Override
    public void pushThis() {
        this.myCode.addInstr((short)42);
        this.growStack(1, this.cb.classType);
    }

    @Override
    public void push(byte by) {
        this.push(by, Type.BYTE);
    }

    @Override
    public void push(boolean bl) {
        this.push(bl ? 1 : 0, Type.BOOLEAN);
    }

    @Override
    public void push(short s2) {
        this.push(s2, Type.SHORT);
    }

    @Override
    public void push(int n) {
        this.push(n, Type.INT);
    }

    @Override
    public void dup() {
        Type type = this.popStack();
        this.myCode.addInstr(type.width() == 2 ? (short)92 : 89);
        this.growStack(type);
        this.growStack(type);
    }

    @Override
    public void swap() {
        Type type = this.popStack();
        Type type2 = this.popStack();
        this.growStack(type);
        this.growStack(type2);
        if (type.width() == 1) {
            if (type2.width() == 1) {
                this.myCode.addInstr((short)95);
                return;
            }
            this.myCode.addInstr((short)91);
            this.myCode.addInstr((short)87);
        } else if (type2.width() == 1) {
            this.myCode.addInstr((short)93);
            this.myCode.addInstr((short)88);
        } else {
            this.myCode.addInstr((short)94);
            this.myCode.addInstr((short)88);
        }
        this.growStack(type);
        this.popStack();
    }

    private void push(int n, Type type) {
        CodeChunk codeChunk = this.myCode;
        if (n >= -1 && n <= 5) {
            codeChunk.addInstr((short)(3 + n));
        } else if (n >= -128 && n <= 127) {
            codeChunk.addInstrU1((short)16, n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            codeChunk.addInstrU2((short)17, n);
        } else {
            int n2 = this.modClass.addConstant(n);
            this.addInstrCPE((short)18, n2);
        }
        this.growStack(type.width(), type);
    }

    @Override
    public void push(long l) {
        CodeChunk codeChunk = this.myCode;
        if (l == 0L || l == 1L) {
            short s2 = l == 0L ? (short)9 : 10;
            codeChunk.addInstr(s2);
        } else {
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                this.push((int)l, Type.LONG);
                codeChunk.addInstr((short)133);
                return;
            }
            int n = this.modClass.addConstant(l);
            codeChunk.addInstrU2((short)20, n);
        }
        this.growStack(2, Type.LONG);
    }

    @Override
    public void push(float f) {
        CodeChunk codeChunk = this.myCode;
        if ((double)f == 0.0) {
            codeChunk.addInstr((short)11);
        } else if ((double)f == 1.0) {
            codeChunk.addInstr((short)12);
        } else if ((double)f == 2.0) {
            codeChunk.addInstr((short)13);
        } else {
            int n = this.modClass.addConstant(f);
            this.addInstrCPE((short)18, n);
        }
        this.growStack(1, Type.FLOAT);
    }

    @Override
    public void push(double d) {
        CodeChunk codeChunk = this.myCode;
        if (d == 0.0) {
            codeChunk.addInstr((short)14);
        } else {
            int n = this.modClass.addConstant(d);
            codeChunk.addInstrU2((short)20, n);
        }
        this.growStack(2, Type.DOUBLE);
    }

    @Override
    public void push(String string) {
        int n = this.modClass.addConstant(string);
        this.addInstrCPE((short)18, n);
        this.growStack(1, Type.STRING);
    }

    @Override
    public void methodReturn() {
        short s2;
        if (this.stackDepth != 0) {
            Type type = this.popStack();
            s2 = CodeChunk.RETURN_OPCODE[type.vmType()];
        } else {
            s2 = 177;
        }
        this.myCode.addInstr(s2);
    }

    @Override
    public Object describeMethod(short s2, String string, String string2, String string3) {
        Type type = this.cb.factory.type(string3);
        String string4 = BCMethodDescriptor.get(BCMethodDescriptor.EMPTY, type.vmName(), this.cb.factory);
        if (string == null && s2 != 184) {
            Type type2 = this.stackTypes[this.stackTypeOffset - 1];
            if (string == null) {
                string = type2.javaName();
            }
        }
        int n = this.modClass.addMethodReference(string, string2, string4, s2 == 185);
        return new BCMethodCaller(s2, type, n);
    }

    @Override
    public int callMethod(Object object) {
        this.popStack();
        BCMethodCaller bCMethodCaller = (BCMethodCaller)object;
        int n = bCMethodCaller.cpi;
        short s2 = bCMethodCaller.opcode;
        if (s2 == 185) {
            this.myCode.addInstrU2U1U1(s2, n, (short)1, (short)0);
        } else {
            this.myCode.addInstrU2(s2, n);
        }
        Type type = bCMethodCaller.type;
        int n2 = type.width();
        if (n2 != 0) {
            this.growStack(n2, type);
        } else {
            this.overflowMethodCheck();
        }
        return n;
    }

    @Override
    public int callMethod(short s2, String string, String string2, String string3, int n) {
        Type type;
        Type type2;
        String[] stringArray;
        Type type3 = this.cb.factory.type(string3);
        int n2 = this.stackDepth;
        Object var8_8 = null;
        if (n == 0) {
            stringArray = BCMethodDescriptor.EMPTY;
        } else {
            stringArray = new String[n];
            for (int i = n - 1; i >= 0; --i) {
                type2 = this.popStack();
                stringArray[i] = type2.vmName();
            }
        }
        String string4 = BCMethodDescriptor.get(stringArray, type3.vmName(), this.cb.factory);
        type2 = null;
        if (s2 != 184) {
            type2 = this.popStack();
        }
        if ((type = this.vmNameDeclaringClass(string)) != null) {
            type2 = type;
        }
        int n3 = this.modClass.addMethodReference(type2.vmNameSimple, string2, string4, s2 == 185);
        if (s2 == 185) {
            short s3 = (short)(n2 - this.stackDepth);
            this.myCode.addInstrU2U1U1(s2, n3, s3, (short)0);
        } else {
            this.myCode.addInstrU2(s2, n3);
        }
        int n4 = type3.width();
        if (n4 != 0) {
            this.growStack(n4, type3);
        } else {
            this.overflowMethodCheck();
        }
        return n3;
    }

    private Type vmNameDeclaringClass(String string) {
        if (string == null) {
            return null;
        }
        return this.cb.factory.type(string);
    }

    @Override
    public void callSuper() {
        this.pushThis();
        this.callMethod((short)183, this.cb.getSuperClassName(), "<init>", "void", 0);
    }

    @Override
    public void pushNewStart(String string) {
        int n = this.modClass.addClassReference(string);
        this.myCode.addInstrU2((short)187, n);
        this.myCode.addInstr((short)89);
        Type type = this.cb.factory.type(string);
        this.growStack(1, type);
        this.growStack(1, type);
    }

    @Override
    public void pushNewComplete(int n) {
        this.callMethod((short)183, null, "<init>", "void", n);
    }

    @Override
    public void upCast(String string) {
        Type type;
        this.stackTypes[this.stackTypeOffset - 1] = type = this.cb.factory.type(string);
    }

    @Override
    public void cast(String string) {
        Type type = this.stackTypes[this.stackTypeOffset - 1];
        short s2 = type.vmType();
        if (s2 == 7 && string.equals(type.javaName())) {
            return;
        }
        Type type2 = this.cb.factory.type(string);
        this.popStack();
        short s3 = type2.vmType();
        if (s2 == 7) {
            int n = this.modClass.addClassReference(type2.vmNameSimple);
            this.myCode.addInstrU2((short)192, n);
        } else {
            short s4 = 0;
            while (s2 != s3 && s4 != -999) {
                short[] sArray = CodeChunk.CAST_CONVERSION_INFO[s2][s3];
                s2 = sArray[1];
                s4 = sArray[0];
                if (s4 == 0) continue;
                this.myCode.addInstr(s4);
            }
        }
        this.growStack(type2);
    }

    @Override
    public void isInstanceOf(String string) {
        int n = this.modClass.addClassReference(string);
        this.myCode.addInstrU2((short)193, n);
        this.popStack();
        this.growStack(1, Type.BOOLEAN);
    }

    @Override
    public void pushNull(String string) {
        this.myCode.addInstr((short)1);
        this.growStack(1, this.cb.factory.type(string));
    }

    @Override
    public void getField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        Type type = bCLocalField.type;
        this.pushThis();
        this.myCode.addInstrU2((short)180, bCLocalField.cpi);
        this.popStack();
        this.growStack(type);
    }

    @Override
    public void getField(String string, String string2, String string3) {
        Type type = this.popStack();
        Type type2 = this.vmNameDeclaringClass(string);
        if (type2 != null) {
            type = type2;
        }
        this.getField((short)180, type.vmNameSimple, string2, string3);
    }

    @Override
    public void getStaticField(String string, String string2, String string3) {
        this.getField((short)178, string, string2, string3);
    }

    private void getField(short s2, String string, String string2, String string3) {
        Type type = this.cb.factory.type(string3);
        int n = this.modClass.addFieldReference(this.vmNameDeclaringClass((String)string).vmNameSimple, string2, type.vmName());
        this.myCode.addInstrU2(s2, n);
        this.growStack(type);
    }

    @Override
    public void setField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        this.putField(bCLocalField.type, bCLocalField.cpi, false);
        this.overflowMethodCheck();
    }

    @Override
    public void putField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        this.putField(bCLocalField.type, bCLocalField.cpi, true);
    }

    @Override
    public void putField(String string, String string2) {
        Type type = this.cb.factory.type(string2);
        int n = this.modClass.addFieldReference(this.cb.classType.vmNameSimple, string, type.vmName());
        this.putField(type, n, true);
    }

    private void putField(Type type, int n, boolean bl) {
        if (bl) {
            this.myCode.addInstr(type.width() == 2 ? (short)92 : 89);
            this.growStack(type);
        }
        this.pushThis();
        this.swap();
        this.myCode.addInstrU2((short)181, n);
        this.popStack();
        this.popStack();
    }

    @Override
    public void putField(String string, String string2, String string3) {
        Type type = this.popStack();
        Type type2 = this.popStack();
        this.myCode.addInstr(type.width() == 2 ? (short)93 : 90);
        this.growStack(type);
        this.growStack(type2);
        this.growStack(type);
        Type type3 = this.vmNameDeclaringClass(string);
        if (type3 != null) {
            type2 = type3;
        }
        Type type4 = this.cb.factory.type(string3);
        int n = this.modClass.addFieldReference(type2.vmNameSimple, string2, type4.vmName());
        this.myCode.addInstrU2((short)181, n);
        this.popStack();
        this.popStack();
    }

    @Override
    public void conditionalIfNull() {
        this.conditionalIf((short)199);
    }

    @Override
    public void conditionalIf() {
        this.conditionalIf((short)153);
    }

    private void conditionalIf(short s2) {
        this.popStack();
        this.condition = new Conditional(this.condition, this.myCode, s2, this.copyStack());
    }

    @Override
    public void startElseCode() {
        Type[] typeArray = this.condition.startElse(this, this.myCode, this.copyStack());
        this.stackDepth = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            this.stackTypes[i] = typeArray[i];
            this.stackDepth += this.stackTypes[i].width();
        }
        this.stackTypeOffset = typeArray.length;
    }

    @Override
    public void completeConditional() {
        this.condition = this.condition.end(this, this.myCode, this.stackTypes, this.stackTypeOffset);
    }

    @Override
    public void pop() {
        Type type = this.popStack();
        this.myCode.addInstr(type.width() == 2 ? (short)88 : 87);
        this.overflowMethodCheck();
    }

    @Override
    public void endStatement() {
        if (this.stackDepth != 0) {
            this.pop();
        }
    }

    @Override
    public void getArrayElement(int n) {
        this.push(n);
        this.popStack();
        Type type = this.popStack();
        String string = type.javaName();
        String string2 = string.substring(0, string.length() - 2);
        Type type2 = this.cb.factory.type(string2);
        short s2 = type2.vmType();
        if (s2 == 2 && type2.vmName().equals("Z")) {
            s2 = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_ACCESS[s2]);
        this.growStack(type2);
    }

    @Override
    public void setArrayElement(int n) {
        this.push(n);
        this.swap();
        Type type = this.popStack();
        this.popStack();
        this.popStack();
        short s2 = type.vmType();
        if (s2 == 2 && type.vmName().equals("Z")) {
            s2 = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_STORE[s2]);
    }

    @Override
    public void pushNewArray(String string, int n) {
        this.push(n);
        this.popStack();
        Type type = this.cb.factory.type(string);
        if (type.vmType() == 7) {
            int n2 = this.modClass.addClassReference(type.javaName());
            this.myCode.addInstrU2((short)189, n2);
        } else {
            int n3 = type.vmType() == 2 && 'Z' == type.vmName().charAt(0) ? 4 : newArrayElementTypeMap[type.vmType()];
            this.myCode.addInstrU1((short)188, n3);
        }
        this.growStack(1, this.cb.factory.type(string.concat("[]")));
    }

    private void addInstrCPE(short s2, int n) {
        if (n >= 65535) {
            this.cb.addLimitExceeded(this, "constant_pool_count", 65535, n);
        }
        this.myCode.addInstrCPE(s2, n);
    }

    @Override
    public boolean statementNumHitLimit(int n) {
        if (this.statementNum > 2048) {
            return true;
        }
        this.statementNum += n;
        return false;
    }

    private void overflowMethodCheck() {
        if (this.stackDepth != 0) {
            return;
        }
        if (this.handlingOverflow) {
            return;
        }
        if (this.condition != null) {
            return;
        }
        int n = this.myCode.getPC();
        if (n < 55000) {
            return;
        }
        if (this.parameters != null && this.parameters.length != 0) {
            return;
        }
        BCMethod bCMethod = this.getNewSubMethod(this.myReturnType, false);
        this.handlingOverflow = true;
        this.callSubMethod(bCMethod);
        this.methodReturn();
        this.complete();
        this.handlingOverflow = false;
        this.myEntry = bCMethod.myEntry;
        this.myCode = bCMethod.myCode;
        this.currentVarNum = bCMethod.currentVarNum;
        this.statementNum = bCMethod.statementNum;
        this.stackTypes = bCMethod.stackTypes;
        this.stackTypeOffset = bCMethod.stackTypeOffset;
        this.maxStack = bCMethod.maxStack;
        this.stackDepth = bCMethod.stackDepth;
    }

    final BCMethod getNewSubMethod(String string, boolean bl) {
        int n = this.myEntry.getModifier();
        n &= 0xFFFFFFFA;
        String string2 = this.myName + "_s" + Integer.toString(this.subMethodCount++);
        BCMethod bCMethod = (BCMethod)this.cb.newMethodBuilder(n |= 2, string, string2, bl ? this.parameterTypes : null);
        bCMethod.thrownExceptions = this.thrownExceptions;
        return bCMethod;
    }

    final void callSubMethod(BCMethod bCMethod) {
        short s2;
        if ((this.myEntry.getModifier() & 8) == 0) {
            s2 = 182;
            this.pushThis();
        } else {
            s2 = 184;
        }
        int n = bCMethod.parameters == null ? 0 : bCMethod.parameters.length;
        for (int i = 0; i < n; ++i) {
            this.getParameter(i);
        }
        this.callMethod(s2, this.modClass.getName(), bCMethod.getName(), bCMethod.myReturnType, n);
    }
}

