/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.MetricData;

public class SourceMetricData
implements MetricData {
    private final MetricGroup metricGroup;
    private final String groupId;
    private final String streamId;
    private final String nodeId;
    private Counter numRecordsIn;
    private Counter numBytesIn;
    private Meter numRecordsInPerSecond;
    private Meter numBytesInPerSecond;
    private final AuditImp auditImp;

    public SourceMetricData(String groupId, String streamId, String nodeId, MetricGroup metricGroup) {
        this(groupId, streamId, nodeId, metricGroup, null);
    }

    public SourceMetricData(String groupId, String streamId, String nodeId, MetricGroup metricGroup, AuditImp auditImp) {
        this.groupId = groupId;
        this.streamId = streamId;
        this.nodeId = nodeId;
        this.metricGroup = metricGroup;
        this.auditImp = auditImp;
    }

    public void registerMetricsForNumRecordsIn() {
        this.registerMetricsForNumRecordsIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsIn(Counter counter) {
        this.numRecordsIn = this.registerCounter("numRecordsIn", counter);
    }

    public void registerMetricsForNumBytesIn() {
        this.registerMetricsForNumBytesIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesIn(Counter counter) {
        this.numBytesIn = this.registerCounter("numBytesIn", counter);
    }

    public void registerMetricsForNumRecordsInPerSecond() {
        this.numRecordsInPerSecond = this.registerMeter("numRecordsInPerSecond", this.numRecordsIn);
    }

    public void registerMetricsForNumBytesInPerSecond() {
        this.numBytesInPerSecond = this.registerMeter("numBytesInPerSecond", this.numBytesIn);
    }

    public Counter getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public Counter getNumBytesIn() {
        return this.numBytesIn;
    }

    public Meter getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public Meter getNumBytesInPerSecond() {
        return this.numBytesInPerSecond;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void outputMetrics(long rowCountSize, long rowDataSize) {
        this.outputMetricForFlink(rowCountSize, rowDataSize);
        this.outputMetricForAudit(rowCountSize, rowDataSize);
    }

    public void outputMetricForAudit(long rowCountSize, long rowDataSize) {
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_INPUT, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCountSize, rowDataSize);
        }
    }

    public void outputMetricForFlink(long rowCountSize, long rowDataSize) {
        this.numBytesIn.inc(rowDataSize);
        this.numRecordsIn.inc(rowCountSize);
    }
}

