/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.relational.TableId;
import io.debezium.util.HexConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowMapper.class);
    public static final int INSERT = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    public static final int DDL = 5;
    public static final int COMMIT = 7;
    public static final int MISSING_SCN = 34;
    public static final int ROLLBACK = 36;
    private static final int SCN = 1;
    private static final int SQL_REDO = 2;
    private static final int OPERATION_CODE = 3;
    private static final int CHANGE_TIME = 4;
    private static final int TX_ID = 5;
    private static final int CSF = 6;
    private static final int TABLE_NAME = 7;
    private static final int SEG_OWNER = 8;
    private static final int OPERATION = 9;
    private static final int USERNAME = 10;
    private static final int ROW_ID = 11;
    private static final int ROLLBACK_FLAG = 12;
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));

    public static String getOperation(ResultSet rs) throws SQLException {
        return rs.getString(9);
    }

    public static String getUsername(ResultSet rs) throws SQLException {
        return rs.getString(10);
    }

    public static int getOperationCode(ResultSet rs) throws SQLException {
        return rs.getInt(3);
    }

    public static String getTableName(ResultSet rs) throws SQLException {
        return rs.getString(7);
    }

    public static String getSegOwner(ResultSet rs) throws SQLException {
        return rs.getString(8);
    }

    public static Timestamp getChangeTime(ResultSet rs) throws SQLException {
        return rs.getTimestamp(4, UTC_CALENDAR);
    }

    public static Scn getScn(ResultSet rs) throws SQLException {
        String scn = rs.getString(1);
        if (scn == null) {
            return Scn.NULL;
        }
        return Scn.valueOf(scn);
    }

    public static String getTransactionId(ResultSet rs) throws SQLException {
        return HexConverter.convertToHexString(rs.getBytes(5));
    }

    public static String getSqlRedo(ResultSet rs, boolean isDml, HistoryRecorder historyRecorder, Scn scn, String tableName, String segOwner, int operationCode, Timestamp changeTime, String txId) throws SQLException {
        int lobLimitCounter = 9;
        String redoSql = rs.getString(2);
        if (redoSql == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(redoSql);
        int csf = rs.getInt(6);
        if (isDml) {
            historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, csf, redoSql);
        }
        while (csf == 1) {
            rs.next();
            if (lobLimitCounter-- == 0) {
                LOGGER.warn("LOB value was truncated due to the connector limitation of {} MB", (Object)40);
                break;
            }
            result.append(rs.getString(2));
            csf = rs.getInt(6);
            if (!isDml) continue;
            historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, csf, rs.getString(2));
        }
        return result.toString();
    }

    public static String getRowId(ResultSet rs) throws SQLException {
        return rs.getString(11);
    }

    public static int getRollbackFlag(ResultSet rs) throws SQLException {
        return rs.getInt(12);
    }

    public static TableId getTableId(String catalogName, ResultSet rs) throws SQLException {
        return new TableId(catalogName, rs.getString(8), rs.getString(7));
    }
}

