/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerHelper {
    private static final String CURRENT = "CURRENT";
    private static final String UNKNOWN = "unknown";
    private static final String TOTAL = "TOTAL";
    private static final String ALL_COLUMN_LOGGING = "ALL COLUMN LOGGING";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerHelper.class);
    private static Map<String, OracleConnection> racFlushConnections = new HashMap<String, OracleConnection>();

    static void instantiateFlushConnections(JdbcConfiguration config, Set<String> hosts) {
        for (OracleConnection conn : racFlushConnections.values()) {
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Cannot close existing RAC flush connection", (Throwable)e);
            }
        }
        racFlushConnections = new HashMap<String, OracleConnection>();
        for (String host : hosts) {
            try {
                racFlushConnections.put(host, LogMinerHelper.createFlushConnection(config, host));
            }
            catch (SQLException e) {
                LOGGER.error("Cannot connect to RAC node {}", (Object)host, (Object)e);
            }
        }
    }

    static void buildDataDictionary(OracleConnection connection) throws SQLException {
        LOGGER.trace("Building data dictionary");
        LogMinerHelper.executeCallableStatement(connection, "BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;");
    }

    /*
     * Exception decompiling
     */
    public static Scn getCurrentScn(OracleConnection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void createFlushTable(OracleConnection connection) throws SQLException {
        String recordExists;
        String tableExists = (String)LogMinerHelper.getSingleResult(connection, SqlUtils.tableExistsQuery("LOG_MINING_FLUSH"), DATATYPE.STRING);
        if (tableExists == null) {
            LogMinerHelper.executeCallableStatement(connection, "CREATE TABLE LOG_MINING_FLUSH(LAST_SCN NUMBER(19,0))");
        }
        if ((recordExists = (String)LogMinerHelper.getSingleResult(connection, "SELECT '1' AS ONE FROM LOG_MINING_FLUSH", DATATYPE.STRING)) == null) {
            LogMinerHelper.executeCallableStatement(connection, "INSERT INTO LOG_MINING_FLUSH VALUES(0)");
            connection.commit();
        }
    }

    static Scn getEndScn(OracleConnection connection, Scn startScn, OracleStreamingChangeEventSourceMetrics streamingMetrics, int defaultBatchSize) throws SQLException {
        Scn currentScn = LogMinerHelper.getCurrentScn(connection);
        streamingMetrics.setCurrentScn(currentScn);
        Scn topScnToMine = startScn.add(Scn.valueOf(streamingMetrics.getBatchSize()));
        boolean topMiningScnInFarFuture = false;
        if (topScnToMine.subtract(currentScn).compareTo(Scn.valueOf(defaultBatchSize)) > 0) {
            streamingMetrics.changeBatchSize(false);
            topMiningScnInFarFuture = true;
        }
        if (currentScn.subtract(topScnToMine).compareTo(Scn.valueOf(defaultBatchSize)) > 0) {
            streamingMetrics.changeBatchSize(true);
        }
        if (currentScn.compareTo(topScnToMine) < 0) {
            if (!topMiningScnInFarFuture) {
                streamingMetrics.changeSleepingTime(true);
            }
            return currentScn;
        }
        streamingMetrics.changeSleepingTime(false);
        return topScnToMine;
    }

    static void flushLogWriter(OracleConnection connection, JdbcConfiguration config, boolean isRac, Set<String> racHosts) throws SQLException {
        Scn currentScn = LogMinerHelper.getCurrentScn(connection);
        if (isRac) {
            LogMinerHelper.flushRacLogWriters(currentScn, config, racHosts);
        } else {
            LOGGER.trace("Updating {} with SCN {}", (Object)"LOG_MINING_FLUSH", (Object)currentScn);
            LogMinerHelper.executeCallableStatement(connection, "UPDATE LOG_MINING_FLUSH SET LAST_SCN =" + currentScn);
            connection.commit();
        }
    }

    static OffsetDateTime getSystime(OracleConnection connection) throws SQLException {
        return connection.queryAndMap("SELECT SYSTIMESTAMP FROM DUAL", rs -> {
            if (rs.next()) {
                return rs.getObject(1, OffsetDateTime.class);
            }
            return null;
        });
    }

    static void startLogMining(OracleConnection connection, Scn startScn, Scn endScn, OracleConnectorConfig.LogMiningStrategy strategy, boolean isContinuousMining, OracleStreamingChangeEventSourceMetrics streamingMetrics) throws SQLException {
        LOGGER.trace("Starting log mining startScn={}, endScn={}, strategy={}, continuous={}", new Object[]{startScn, endScn, strategy, isContinuousMining});
        String statement = SqlUtils.startLogMinerStatement(startScn, endScn, strategy, isContinuousMining);
        try {
            Instant start = Instant.now();
            LogMinerHelper.executeCallableStatement(connection, statement);
            streamingMetrics.addCurrentMiningSessionStart(Duration.between(start, Instant.now()));
        }
        catch (SQLException e) {
            LogMinerHelper.logDatabaseState(connection);
            throw e;
        }
    }

    static Set<String> getCurrentRedoLogFiles(OracleConnection connection) throws SQLException {
        HashSet<String> fileNames = new HashSet<String>();
        connection.query(SqlUtils.currentRedoNameQuery(), rs -> {
            while (rs.next()) {
                fileNames.add(rs.getString(1));
            }
        });
        LOGGER.trace(" Current Redo log fileNames: {} ", fileNames);
        return fileNames;
    }

    /*
     * Exception decompiling
     */
    static Scn getFirstOnlineLogScn(OracleConnection connection, Duration archiveLogRetention) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void setNlsSessionParameters(JdbcConnection connection) throws SQLException {
        connection.executeWithoutCommitting("ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'");
        connection.executeWithoutCommitting("ALTER SESSION SET TIME_ZONE = '00:00'");
    }

    private static Map<String, String> getRedoLogStatus(OracleConnection connection) throws SQLException {
        return LogMinerHelper.getMap(connection, SqlUtils.redoLogStatusQuery(), UNKNOWN);
    }

    private static int getSwitchCount(OracleConnection connection) {
        try {
            Map<String, String> total = LogMinerHelper.getMap(connection, SqlUtils.switchHistoryQuery(), UNKNOWN);
            if (total != null && total.get(TOTAL) != null) {
                return Integer.parseInt(total.get(TOTAL));
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get switch counter", (Throwable)e);
        }
        return 0;
    }

    private static void flushRacLogWriters(Scn currentScn, JdbcConfiguration config, Set<String> racHosts) {
        Instant startTime = Instant.now();
        if (racHosts.isEmpty()) {
            throw new RuntimeException("No RAC node ip addresses were supplied in the configuration");
        }
        boolean errors = false;
        for (String host : racHosts) {
            try {
                OracleConnection conn = racFlushConnections.get(host);
                if (conn == null) {
                    LOGGER.warn("Connection to the node {} was not instantiated", (Object)host);
                    errors = true;
                    continue;
                }
                LOGGER.trace("Flushing Log Writer buffer of node {}", (Object)host);
                LogMinerHelper.executeCallableStatement(conn, "UPDATE LOG_MINING_FLUSH SET LAST_SCN =" + currentScn);
                conn.commit();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot flush Log Writer buffer of the node {} due to {}", (Object)host, (Object)e);
                errors = true;
            }
        }
        if (errors) {
            LogMinerHelper.instantiateFlushConnections(config, racHosts);
            LOGGER.warn("Not all LogWriter buffers were flushed. Sleeping for 3 seconds to let Oracle do the flush.", racHosts);
            Metronome metronome = Metronome.sleeper(Duration.ofMillis(3000L), Clock.system());
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Metronome was interrupted");
            }
        }
        LOGGER.trace("Flushing RAC Log Writers took {} ", (Object)Duration.between(startTime, Instant.now()));
    }

    private static OracleConnection createFlushConnection(JdbcConfiguration config, String host) throws SQLException {
        JdbcConfiguration hostConfig = JdbcConfiguration.adapt(((Configuration.Builder)config.edit().with(JdbcConfiguration.DATABASE, host)).build());
        OracleConnection connection = new OracleConnection((Configuration)hostConfig, () -> LogMinerHelper.class.getClassLoader());
        connection.setAutoCommit(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkSupplementalLogging(OracleConnection connection, String pdbName, OracleDatabaseSchema schema) throws SQLException {
        try {
            Map<String, String> globalAll;
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            if ("NO".equalsIgnoreCase((globalAll = LogMinerHelper.getMap(connection, SqlUtils.databaseSupplementalLoggingAllCheckQuery(), UNKNOWN)).get("KEY"))) {
                Map<String, String> globalMin = LogMinerHelper.getMap(connection, SqlUtils.databaseSupplementalLoggingMinCheckQuery(), UNKNOWN);
                if ("NO".equalsIgnoreCase(globalMin.get("KEY"))) {
                    throw new DebeziumException("Supplemental logging not properly configured.  Use: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA");
                }
                for (TableId tableId : schema.getTables().tableIds()) {
                    if (LogMinerHelper.isTableSupplementalLogDataAll(connection, tableId)) continue;
                    throw new DebeziumException("Supplemental logging not configured for table " + tableId + ".  Use command: ALTER TABLE " + tableId.schema() + "." + tableId.table() + " ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS");
                }
            }
        }
        finally {
            if (pdbName != null) {
                connection.resetSessionToCdb();
            }
        }
    }

    static boolean isTableSupplementalLogDataAll(OracleConnection connection, TableId tableId) throws SQLException {
        return connection.queryAndMap(SqlUtils.tableSupplementalLoggingCheckQuery(tableId), rs -> {
            while (rs.next()) {
                if (!ALL_COLUMN_LOGGING.equals(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    public static void endMining(OracleConnection connection) {
        String stopMining = "BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;";
        try {
            LogMinerHelper.executeCallableStatement(connection, stopMining);
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("LogMiner session was already closed");
            }
            LOGGER.error("Cannot close LogMiner session gracefully: {}", (Throwable)e);
        }
    }

    public static void setRedoLogFilesForMining(OracleConnection connection, Scn lastProcessedScn, Duration archiveLogRetention) throws SQLException {
        boolean hasOverlappingLogFile;
        LogMinerHelper.removeLogFilesFromMining(connection);
        List<LogFile> onlineLogFilesForMining = LogMinerHelper.getOnlineLogFilesForOffsetScn(connection, lastProcessedScn);
        List<LogFile> archivedLogFilesForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn(connection, lastProcessedScn, archiveLogRetention);
        boolean bl = hasOverlappingLogFile = onlineLogFilesForMining.stream().anyMatch(l -> l.getFirstScn().compareTo(lastProcessedScn) <= 0) || archivedLogFilesForMining.stream().anyMatch(l -> l.getFirstScn().compareTo(lastProcessedScn) <= 0);
        if (!hasOverlappingLogFile) {
            throw new IllegalStateException("None of log files contains offset SCN: " + lastProcessedScn + ", re-snapshot is required.");
        }
        List logFilesNames = archivedLogFilesForMining.stream().map(LogFile::getFileName).collect(Collectors.toList());
        for (LogFile redoLog : onlineLogFilesForMining) {
            boolean found = false;
            for (LogFile archiveLog : archivedLogFilesForMining) {
                if (!archiveLog.isSameRange(redoLog)) continue;
                found = true;
                break;
            }
            if (found) continue;
            logFilesNames.add(redoLog.getFileName());
        }
        for (String file : logFilesNames) {
            LOGGER.trace("Adding log file {} to mining session", (Object)file);
            String addLogFileStatement = SqlUtils.addLogFileStatement("DBMS_LOGMNR.ADDFILE", file);
            LogMinerHelper.executeCallableStatement(connection, addLogFileStatement);
        }
        LOGGER.debug("Last mined SCN: {}, Log file list to mine: {}\n", (Object)lastProcessedScn, logFilesNames);
    }

    public static Optional<Scn> getLastScnToAbandon(OracleConnection connection, Scn offsetScn, Duration transactionRetention) {
        try {
            String query = SqlUtils.diffInDaysQuery(offsetScn);
            Float diffInDays = (Float)LogMinerHelper.getSingleResult(connection, query, DATATYPE.FLOAT);
            if (diffInDays != null && diffInDays.floatValue() * 24.0f > (float)transactionRetention.toHours()) {
                return Optional.of(offsetScn);
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            LOGGER.error("Cannot calculate days difference due to {}", (Throwable)e);
            return Optional.of(offsetScn);
        }
    }

    static void logWarn(OracleStreamingChangeEventSourceMetrics streamingMetrics, String format, Object ... args) {
        LOGGER.warn(format, args);
        streamingMetrics.incrementWarningCount();
    }

    static void logError(OracleStreamingChangeEventSourceMetrics streamingMetrics, String format, Object ... args) {
        LOGGER.error(format, args);
        streamingMetrics.incrementErrorCount();
    }

    public static List<LogFile> getOnlineLogFilesForOffsetScn(OracleConnection connection, Scn offsetScn) throws SQLException {
        LOGGER.trace("Getting online redo logs for offset scn {}", (Object)offsetScn);
        ArrayList<LogFile> redoLogFiles = new ArrayList<LogFile>();
        try (PreparedStatement s = connection.connection(false).prepareStatement(SqlUtils.allOnlineLogsQuery());
             ResultSet rs = s.executeQuery();){
            while (rs.next()) {
                String status;
                String fileName = rs.getString(1);
                Scn nextChangeNumber = LogMinerHelper.getScnFromString(rs.getString(2));
                Scn firstChangeNumber = LogMinerHelper.getScnFromString(rs.getString(4));
                LogFile logFile = new LogFile(fileName, firstChangeNumber, nextChangeNumber, CURRENT.equalsIgnoreCase(status = rs.getString(5)));
                if (logFile.isCurrent() || logFile.getNextScn().compareTo(offsetScn) >= 0) {
                    LOGGER.trace("Online redo log {} with SCN range {} to {} ({}) to be added.", new Object[]{fileName, firstChangeNumber, nextChangeNumber, status});
                    redoLogFiles.add(logFile);
                    continue;
                }
                LOGGER.trace("Online redo log {} with SCN range {} to {} ({}) to be excluded.", new Object[]{fileName, firstChangeNumber, nextChangeNumber, status});
            }
        }
        return redoLogFiles;
    }

    private static Scn getScnFromString(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return Scn.MAX;
        }
        return Scn.valueOf(value);
    }

    private static void logDatabaseState(OracleConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured redo logs are:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$LOGFILE");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain redo log table entries", (Throwable)e);
            }
            LOGGER.debug("Available archive logs are:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$ARCHIVED_LOG");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain archive log table entries", (Throwable)e);
            }
            LOGGER.debug("Available logs are:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$LOG");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log table entries", (Throwable)e);
            }
            LOGGER.debug("Log history last 24 hours:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$LOG_HISTORY WHERE FIRST_TIME >= SYSDATE - 1");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log history", (Throwable)e);
            }
            LOGGER.debug("Log entries registered with LogMiner are:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$LOGMNR_LOGS");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain registered logs with LogMiner", (Throwable)e);
            }
            LOGGER.debug("Log mining session parameters are:");
            try {
                LogMinerHelper.logQueryResults(connection, "SELECT * FROM V$LOGMNR_PARAMETERS");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log mining session parameters", (Throwable)e);
            }
        }
    }

    private static void logQueryResults(OracleConnection connection, String query) throws SQLException {
        connection.query(query, rs -> {
            int columns = rs.getMetaData().getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int index = 1; index <= columns; ++index) {
                columnNames.add(rs.getMetaData().getColumnName(index));
            }
            LOGGER.debug("{}", columnNames);
            while (rs.next()) {
                ArrayList<Object> columnValues = new ArrayList<Object>();
                for (int index = 1; index <= columns; ++index) {
                    columnValues.add(rs.getObject(index));
                }
                LOGGER.debug("{}", columnValues);
            }
        });
    }

    public static List<LogFile> getArchivedLogFilesForOffsetScn(OracleConnection connection, Scn offsetScn, Duration archiveLogRetention) throws SQLException {
        ArrayList<LogFile> archiveLogFiles = new ArrayList<LogFile>();
        try (PreparedStatement s = connection.connection(false).prepareStatement(SqlUtils.archiveLogsQuery(offsetScn, archiveLogRetention));
             ResultSet rs = s.executeQuery();){
            while (rs.next()) {
                Scn nextChangeNumber;
                String fileName = rs.getString(1);
                Scn firstChangeNumber = Scn.valueOf(rs.getString(3));
                Scn scn = nextChangeNumber = rs.getString(2) == null ? Scn.MAX : Scn.valueOf(rs.getString(2));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Archive log {} with SCN range {} to {} to be added.", new Object[]{fileName, firstChangeNumber, nextChangeNumber});
                }
                archiveLogFiles.add(new LogFile(fileName, firstChangeNumber, nextChangeNumber));
            }
        }
        return archiveLogFiles;
    }

    public static void removeLogFilesFromMining(OracleConnection conn) throws SQLException {
        try (PreparedStatement ps = conn.connection(false).prepareStatement("SELECT FILENAME AS NAME FROM V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            LinkedHashSet<String> files = new LinkedHashSet<String>();
            while (result.next()) {
                files.add(result.getString(1));
            }
            for (String fileName : files) {
                LogMinerHelper.executeCallableStatement(conn, SqlUtils.deleteLogFileStatement(fileName));
                LOGGER.debug("File {} was removed from mining", (Object)fileName);
            }
        }
    }

    private static void executeCallableStatement(OracleConnection connection, String statement) throws SQLException {
        Objects.requireNonNull(statement);
        try (CallableStatement s = connection.connection(false).prepareCall(statement);){
            s.execute();
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> getMap(OracleConnection connection, String query, String nullReplacement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object getSingleResult(OracleConnection connection, String query, DATATYPE type) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum DATATYPE {
        LONG,
        TIMESTAMP,
        STRING,
        FLOAT;

    }
}

