/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.antlr.listener.BaseDmlStringParserListener;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.data.Envelope;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteParserListener
extends BaseDmlStringParserListener {
    DeleteParserListener(String catalogName, String schemaName, OracleDmlParser parser) {
        super(catalogName, schemaName, parser);
    }

    @Override
    protected String getKey(Column column, int index) {
        return column.name();
    }

    @Override
    public void enterDelete_statement(PlSqlParser.Delete_statementContext ctx) {
        this.init(ctx.general_table_ref().dml_table_expression_clause());
        this.newColumnValues.clear();
        PlSqlParser.Table_aliasContext tableAlias = ctx.general_table_ref().table_alias();
        this.alias = tableAlias == null ? "" : tableAlias.getText().toUpperCase();
        PlSqlParser.Where_clauseContext where = ctx.where_clause();
        if (where != null) {
            this.parseRecursively(ctx.where_clause().expression().logical_expression());
        } else {
            this.oldColumnValues.clear();
        }
        super.enterDelete_statement(ctx);
    }

    @Override
    public void exitDelete_statement(PlSqlParser.Delete_statementContext ctx) {
        List<LogMinerColumnValue> actualOldValues = this.oldColumnValues.values().stream().map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
        LogMinerDmlEntryImpl newRecord = new LogMinerDmlEntryImpl(Envelope.Operation.DELETE, Collections.emptyList(), actualOldValues);
        this.parser.setDmlEntry(newRecord);
        super.exitDelete_statement(ctx);
    }
}

