/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueImpl;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.ddl.parser.oracle.generated.PlSqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.text.ParsingException;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class BaseDmlParserListener<T>
extends PlSqlParserBaseListener {
    protected String catalogName;
    protected String schemaName;
    protected Table table;
    final OracleValueConverters converter;
    String alias;
    protected OracleDmlParser parser;
    Map<T, LogMinerColumnValueWrapper> newColumnValues = new LinkedHashMap<T, LogMinerColumnValueWrapper>();
    Map<T, LogMinerColumnValueWrapper> oldColumnValues = new LinkedHashMap<T, LogMinerColumnValueWrapper>();

    BaseDmlParserListener(String catalogName, String schemaName, OracleDmlParser parser) {
        this.parser = parser;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.converter = parser.getConverters();
    }

    protected abstract T getKey(Column var1, int var2);

    void init(PlSqlParser.Dml_table_expression_clauseContext ctx) {
        String tableName = ParserUtils.getTableName(ctx.tableview_name());
        this.table = this.parser.databaseTables().forTable(this.catalogName, this.schemaName, tableName);
        if (this.table == null) {
            throw new ParsingException(null, "Trying to parse a table, which does not exist.");
        }
        for (int i = 0; i < this.table.columns().size(); ++i) {
            Column column = this.table.columns().get(i);
            int type = column.jdbcType();
            T key = this.getKey(column, i);
            String name = ParserUtils.stripeQuotes(column.name().toUpperCase());
            this.newColumnValues.put(key, new LogMinerColumnValueWrapper(new LogMinerColumnValueImpl(name, type)));
            this.oldColumnValues.put(key, new LogMinerColumnValueWrapper(new LogMinerColumnValueImpl(name, type)));
        }
    }
}

