/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.tree.ParseTreeListener;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.connector.oracle.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.util.ArrayList;
import java.util.List;

public class AlterTableParserListener
extends BaseParserListener {
    private static final int STARTING_INDEX = 1;
    private TableEditor tableEditor;
    private String catalogName;
    private String schemaName;
    private OracleDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private ColumnDefinitionParserListener columnDefinitionParserListener;
    private List<ColumnEditor> columnEditors;
    private int parsingColumnIndex = 1;

    AlterTableParserListener(String catalogName, String schemaName, OracleDdlParser parser, List<ParseTreeListener> listeners) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.parser = parser;
        this.listeners = listeners;
    }

    @Override
    public void enterAlter_table(PlSqlParser.Alter_tableContext ctx) {
        TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.tableview_name()));
        this.tableEditor = this.parser.databaseTables().editTable(tableId);
        if (this.tableEditor == null) {
            throw new ParsingException(null, "Trying to alter table " + tableId.toString() + ", which does not exist. Query: " + AntlrDdlParser.getText(ctx));
        }
        super.enterAlter_table(ctx);
    }

    @Override
    public void exitAlter_table(PlSqlParser.Alter_tableContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.listeners.remove(this.columnDefinitionParserListener);
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
        }, this.tableEditor);
        super.exitAlter_table(ctx);
    }

    @Override
    public void enterAdd_column_clause(PlSqlParser.Add_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            List<PlSqlParser.Column_definitionContext> columns = ctx.column_definition();
            this.columnEditors = new ArrayList<ColumnEditor>(columns.size());
            for (PlSqlParser.Column_definitionContext column : columns) {
                String columnName = this.getColumnName(column.column_name());
                ColumnEditor editor = Column.editor().name(columnName);
                this.columnEditors.add(editor);
            }
            this.columnDefinitionParserListener = new ColumnDefinitionParserListener(this.tableEditor, this.columnEditors.get(0), this.parser.dataTypeResolver());
            this.listeners.add(this.columnDefinitionParserListener);
        }, this.tableEditor);
        super.enterAdd_column_clause(ctx);
    }

    @Override
    public void exitAdd_column_clause(PlSqlParser.Add_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
            this.listeners.remove(this.columnDefinitionParserListener);
            this.columnDefinitionParserListener = null;
        }, this.tableEditor, this.columnEditors);
        super.exitAdd_column_clause(ctx);
    }

    @Override
    public void exitColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null) {
                if (this.columnEditors.size() > this.parsingColumnIndex) {
                    this.columnDefinitionParserListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
                } else {
                    this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
                    this.columnEditors = null;
                    this.parsingColumnIndex = 1;
                }
            }
        }, this.tableEditor, this.columnEditors);
        super.exitColumn_definition(ctx);
    }

    @Override
    public void enterDrop_column_clause(PlSqlParser.Drop_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            List<PlSqlParser.Column_nameContext> columnNameContexts = ctx.column_name();
            this.columnEditors = new ArrayList<ColumnEditor>(columnNameContexts.size());
            for (PlSqlParser.Column_nameContext columnNameContext : columnNameContexts) {
                String columnName = this.getColumnName(columnNameContext);
                this.tableEditor.removeColumn(columnName);
            }
        }, this.tableEditor);
        super.enterDrop_column_clause(ctx);
    }
}

