/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.CharStream;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.CommonTokenStream;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.tree.ParseTree;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.Locale;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        super(true);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, String catalogName, String schemaName) {
        super(throwErrorsFromTreeWalk);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public void parse(String ddlContent, Tables databaseTables) {
        if (!ddlContent.endsWith(";")) {
            ddlContent = ddlContent + ";";
        }
        super.parse(this.toUpperCase(ddlContent), databaseTables);
    }

    @Override
    public ParseTree parseTree(PlSqlParser parser) {
        return parser.unit_statement();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    @Override
    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    @Override
    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser(commonTokenStream);
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, 691), new DataTypeResolver.DataTypeEntry(2, 683), new DataTypeResolver.DataTypeEntry(2, 1542), new DataTypeResolver.DataTypeEntry(2, 1101), new DataTypeResolver.DataTypeEntry(2, 343), new DataTypeResolver.DataTypeEntry(2, 1100), new DataTypeResolver.DataTypeEntry(93, 327), new DataTypeResolver.DataTypeEntry(-102, 1934), new DataTypeResolver.DataTypeEntry(-101, 1934), new DataTypeResolver.DataTypeEntry(93, 1934), new DataTypeResolver.DataTypeEntry(12, 2076), new DataTypeResolver.DataTypeEntry(12, 2077), new DataTypeResolver.DataTypeEntry(-9, 1105), new DataTypeResolver.DataTypeEntry(1, 176), new DataTypeResolver.DataTypeEntry(-15, 891), new DataTypeResolver.DataTypeEntry(100, 115), new DataTypeResolver.DataTypeEntry(101, 112), new DataTypeResolver.DataTypeEntry(6, 535), new DataTypeResolver.DataTypeEntry(6, 1357), new DataTypeResolver.DataTypeEntry(2004, 128), new DataTypeResolver.DataTypeEntry(2005, 192)));
        return dataTypeResolverBuilder.build();
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    @Override
    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    @Override
    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    private String toUpperCase(String ddl) {
        return ddl.toUpperCase(Locale.ENGLISH);
    }
}

