/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.oracle.SourceInfo;

public class OracleSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.oracle.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_scn", Schema.OPTIONAL_STRING_SCHEMA).field("lcr_position", Schema.OPTIONAL_STRING_SCHEMA).build();

    public OracleSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        String scn = sourceInfo.getScn() == null ? null : sourceInfo.getScn().toString();
        String commitScn = sourceInfo.getCommitScn() == null ? null : sourceInfo.getCommitScn().toString();
        Struct ret = super.commonStruct(sourceInfo).put("schema", (Object)sourceInfo.getTableId().schema()).put("table", (Object)sourceInfo.getTableId().table()).put("txId", (Object)sourceInfo.getTransactionId()).put("scn", (Object)scn);
        if (sourceInfo.getLcrPosition() != null) {
            ret.put("lcr_position", (Object)sourceInfo.getLcrPosition().toString());
        }
        if (commitScn != null) {
            ret.put("commit_scn", (Object)commitScn);
        }
        return ret;
    }
}

