/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.TransactionGenerator;

public class UniformTransactionsGenerator
implements TransactionGenerator {
    private final int messagesPerTransaction;
    private int messagesInTransaction = -1;

    @JsonCreator
    public UniformTransactionsGenerator(@JsonProperty(value="messagesPerTransaction") int messagesPerTransaction) {
        if (messagesPerTransaction < 1) {
            throw new IllegalArgumentException("Cannot have less than one message per transaction.");
        }
        this.messagesPerTransaction = messagesPerTransaction;
    }

    @JsonProperty
    public int messagesPerTransaction() {
        return this.messagesPerTransaction;
    }

    @Override
    public synchronized TransactionGenerator.TransactionAction nextAction() {
        if (this.messagesInTransaction == -1) {
            this.messagesInTransaction = 0;
            return TransactionGenerator.TransactionAction.BEGIN_TRANSACTION;
        }
        if (this.messagesInTransaction == this.messagesPerTransaction) {
            this.messagesInTransaction = -1;
            return TransactionGenerator.TransactionAction.COMMIT_TRANSACTION;
        }
        ++this.messagesInTransaction;
        return TransactionGenerator.TransactionAction.NO_OP;
    }
}

