/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.AbstractStatus;
import java.util.concurrent.atomic.AtomicReference;

public class StateTracker {
    private final AtomicReference<StateChange> lastState = new AtomicReference<StateChange>(new StateChange());

    public synchronized void changeState(AbstractStatus.State newState, long now) {
        this.lastState.set(this.lastState.get().newState(newState, now));
    }

    public double durationRatio(AbstractStatus.State ratioState, long now) {
        return this.lastState.get().durationRatio(ratioState, now);
    }

    public AbstractStatus.State currentState() {
        return this.lastState.get().state;
    }

    private static final class StateChange {
        private final AbstractStatus.State state;
        private final long startTime;
        private final long unassignedTotalTimeMs;
        private final long runningTotalTimeMs;
        private final long pausedTotalTimeMs;
        private final long failedTotalTimeMs;
        private final long destroyedTotalTimeMs;

        StateChange() {
            this(null, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        StateChange(AbstractStatus.State state, long startTime, long unassignedTotalTimeMs, long runningTotalTimeMs, long pausedTotalTimeMs, long failedTotalTimeMs, long destroyedTotalTimeMs) {
            this.state = state;
            this.startTime = startTime;
            this.unassignedTotalTimeMs = unassignedTotalTimeMs;
            this.runningTotalTimeMs = runningTotalTimeMs;
            this.pausedTotalTimeMs = pausedTotalTimeMs;
            this.failedTotalTimeMs = failedTotalTimeMs;
            this.destroyedTotalTimeMs = destroyedTotalTimeMs;
        }

        public StateChange newState(AbstractStatus.State state, long now) {
            if (this.state == null) {
                return new StateChange(state, now, 0L, 0L, 0L, 0L, 0L);
            }
            if (state == this.state) {
                return this;
            }
            long unassignedTime = this.unassignedTotalTimeMs;
            long runningTime = this.runningTotalTimeMs;
            long pausedTime = this.pausedTotalTimeMs;
            long failedTime = this.failedTotalTimeMs;
            long destroyedTime = this.destroyedTotalTimeMs;
            long duration = now - this.startTime;
            switch (this.state) {
                case UNASSIGNED: {
                    unassignedTime += duration;
                    break;
                }
                case RUNNING: {
                    runningTime += duration;
                    break;
                }
                case PAUSED: {
                    pausedTime += duration;
                    break;
                }
                case FAILED: {
                    failedTime += duration;
                    break;
                }
                case DESTROYED: {
                    destroyedTime += duration;
                }
            }
            return new StateChange(state, now, unassignedTime, runningTime, pausedTime, failedTime, destroyedTime);
        }

        public double durationRatio(AbstractStatus.State ratioState, long now) {
            if (this.state == null) {
                return 0.0;
            }
            long durationCurrent = now - this.startTime;
            long durationDesired = ratioState == this.state ? durationCurrent : 0L;
            switch (ratioState) {
                case UNASSIGNED: {
                    durationDesired += this.unassignedTotalTimeMs;
                    break;
                }
                case RUNNING: {
                    durationDesired += this.runningTotalTimeMs;
                    break;
                }
                case PAUSED: {
                    durationDesired += this.pausedTotalTimeMs;
                    break;
                }
                case FAILED: {
                    durationDesired += this.failedTotalTimeMs;
                    break;
                }
                case DESTROYED: {
                    durationDesired += this.destroyedTotalTimeMs;
                }
            }
            long total = durationCurrent + this.unassignedTotalTimeMs + this.runningTotalTimeMs + this.pausedTotalTimeMs + this.failedTotalTimeMs + this.destroyedTotalTimeMs;
            return (double)total == 0.0 ? 0.0 : (double)durationDesired / (double)total;
        }
    }
}

