/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Expression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.schema.Column;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Join;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OrderByVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Select;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.update.Update;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser.LimitDeparser;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;

public class UpdateDeParser
implements OrderByVisitor {
    protected StringBuilder buffer = new StringBuilder();
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();
    private SelectVisitor selectVisitor = new SelectVisitorAdapter();

    public UpdateDeParser() {
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Update update) {
        Column column;
        this.buffer.append("UPDATE ").append(PlainSelect.getStringList(update.getTables(), true, false)).append(" SET ");
        if (!update.isUseSelect()) {
            for (int i = 0; i < update.getColumns().size(); ++i) {
                column = update.getColumns().get(i);
                column.accept(this.expressionVisitor);
                this.buffer.append(" = ");
                Expression expression = update.getExpressions().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= update.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        } else {
            if (update.isUseColumnsBrackets()) {
                this.buffer.append("(");
            }
            for (int i = 0; i < update.getColumns().size(); ++i) {
                if (i != 0) {
                    this.buffer.append(", ");
                }
                column = update.getColumns().get(i);
                column.accept(this.expressionVisitor);
            }
            if (update.isUseColumnsBrackets()) {
                this.buffer.append(")");
            }
            this.buffer.append(" = ");
            this.buffer.append("(");
            Select select = update.getSelect();
            select.getSelectBody().accept(this.selectVisitor);
            this.buffer.append(")");
        }
        if (update.getFromItem() != null) {
            this.buffer.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.buffer.append(", ").append(join);
                        continue;
                    }
                    this.buffer.append(" ").append(join);
                }
            }
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(update.getLimit());
        }
        if (update.isReturningAllColumns()) {
            this.buffer.append(" RETURNING *");
        } else if (update.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ");
            Iterator<SelectExpressionItem> iter = update.getReturningExpressionList().iterator();
            while (iter.hasNext()) {
                this.buffer.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public void visit(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }
}

