/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.create.table.CreateTable;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.create.table.Index;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Select;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser.StatementDeParser;
import java.util.Iterator;

public class CreateTableDeParser {
    protected StringBuilder buffer;
    private StatementDeParser statementDeParser;

    public CreateTableDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public CreateTableDeParser(StatementDeParser statementDeParser, StringBuilder buffer) {
        this.buffer = buffer;
        this.statementDeParser = statementDeParser;
    }

    public void deParse(CreateTable createTable) {
        String params;
        this.buffer.append("CREATE ");
        if (createTable.isUnlogged()) {
            this.buffer.append("UNLOGGED ");
        }
        if (!"".equals(params = PlainSelect.getStringList(createTable.getCreateOptionsStrings(), false, false))) {
            this.buffer.append(params).append(' ');
        }
        this.buffer.append("TABLE ");
        if (createTable.isIfNotExists()) {
            this.buffer.append("IF NOT EXISTS ");
        }
        this.buffer.append(createTable.getTable().getFullyQualifiedName());
        if (createTable.getSelect() != null) {
            this.buffer.append(" AS ");
            if (createTable.isSelectParenthesis()) {
                this.buffer.append("(");
            }
            Select sel = createTable.getSelect();
            sel.accept(this.statementDeParser);
            if (createTable.isSelectParenthesis()) {
                this.buffer.append(")");
            }
        } else if (createTable.getColumnDefinitions() != null) {
            this.buffer.append(" (");
            Iterator<Object> iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = iter.next();
                this.buffer.append(columnDefinition.getColumnName());
                this.buffer.append(" ");
                this.buffer.append(columnDefinition.getColDataType().toString());
                if (columnDefinition.getColumnSpecStrings() != null) {
                    for (String s : columnDefinition.getColumnSpecStrings()) {
                        this.buffer.append(" ");
                        this.buffer.append(s);
                    }
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            if (createTable.getIndexes() != null) {
                iter = createTable.getIndexes().iterator();
                while (iter.hasNext()) {
                    this.buffer.append(", ");
                    Index index = (Index)iter.next();
                    this.buffer.append(index.toString());
                }
            }
            this.buffer.append(")");
        }
        params = PlainSelect.getStringList(createTable.getTableOptionsStrings(), false, false);
        if (!"".equals(params)) {
            this.buffer.append(' ').append(params);
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

