/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Fetch;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Limit;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Offset;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectBody;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SetOperation;
import java.util.List;

public class SetOperationList
implements SelectBody {
    private List<SelectBody> selects;
    private List<Boolean> brackets;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<SelectBody> getSelects() {
        return this.selects;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public List<Boolean> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(List<Boolean> brackets) {
        this.brackets = brackets;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setBracketsOpsAndSelects(List<Boolean> brackets, List<SelectBody> select, List<SetOperation> ops) {
        this.selects = select;
        this.operations = ops;
        this.brackets = brackets;
        if (select.size() - 1 != ops.size() || select.size() != brackets.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.selects.size(); ++i) {
            if (i != 0) {
                buffer.append(" ").append(this.operations.get(i - 1).toString()).append(" ");
            }
            if (this.brackets == null || this.brackets.get(i).booleanValue()) {
                buffer.append("(").append(this.selects.get(i).toString()).append(")");
                continue;
            }
            buffer.append(this.selects.get(i).toString());
        }
        if (this.orderByElements != null) {
            buffer.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            buffer.append(this.limit.toString());
        }
        if (this.offset != null) {
            buffer.append(this.offset.toString());
        }
        if (this.fetch != null) {
            buffer.append(this.fetch.toString());
        }
        return buffer.toString();
    }

    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;

    }
}

