/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.JSQLParserException;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Expression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.CCJSqlParser;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.Node;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.ParseException;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.StatementListener;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.StreamProvider;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.StringProvider;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.Statement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.Statements;
import java.io.InputStream;
import java.io.Reader;

public final class CCJSqlParserUtil {
    private CCJSqlParserUtil() {
    }

    public static Statement parse(Reader statementReader) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StreamProvider(statementReader));
        try {
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(String sql) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StringProvider(sql));
        try {
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Node parseAST(String sql) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StringProvider(sql));
        try {
            parser.Statement();
            return parser.jjtree.rootNode();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is) throws JSQLParserException {
        try {
            CCJSqlParser parser = new CCJSqlParser(new StreamProvider(is));
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = new CCJSqlParser(new StreamProvider(is, encoding));
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseExpression(String expression) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, true);
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StringProvider(expression));
        try {
            Expression expr = parser.SimpleExpression();
            if (!allowPartialParse && parser.getNextToken().kind != 0) {
                throw new JSQLParserException("could only parse partial expression " + expr.toString());
            }
            return expr;
        }
        catch (JSQLParserException ex) {
            throw ex;
        }
        catch (ParseException ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseCondExpression(String condExpr) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, true);
    }

    public static Expression parseCondExpression(String condExpr, boolean allowPartialParse) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StringProvider(condExpr));
        try {
            Expression expr = parser.Expression();
            if (!allowPartialParse && parser.getNextToken().kind != 0) {
                throw new JSQLParserException("could only parse partial expression " + expr.toString());
            }
            return expr;
        }
        catch (JSQLParserException ex) {
            throw ex;
        }
        catch (ParseException ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statements parseStatements(String sqls) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StringProvider(sqls));
        try {
            return parser.Statements();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static void streamStatements(StatementListener listener, InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = new CCJSqlParser(new StreamProvider(is, encoding));
            do {
                Statement stmt = parser.SingleStatement();
                listener.accept(stmt);
                if (parser.getToken((int)1).kind != 196) continue;
                parser.getNextToken();
            } while (parser.getToken((int)1).kind != 0);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }
}

