/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sdk.transform.encode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * DefaultSinkData
 * 
 */
public class DefaultSinkData implements SinkData {

    private List<String> keyList = new ArrayList<>();
    private Map<String, String> currentRow = new HashMap<>();

    /**
     * addField
     * @param fieldName
     * @param fieldValue
     */
    @Override
    public void addField(String fieldName, String fieldValue) {
        this.keyList.add(fieldName);
        this.currentRow.put(fieldName, fieldValue);
    }

    /**
     * getField
     * @param fieldName
     * @return
     */
    @Override
    public String getField(String fieldName) {
        return this.currentRow.getOrDefault(fieldName, "");
    }

    /**
     * keyList
     * @return
     */
    @Override
    public List<String> keyList() {
        return this.keyList;
    }
}
