#!/bin/bash
#
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# this program kills the audit service
for i in {1..5}
do
  pid=$(ps aux | grep "audit-service" | grep -v "grep" | awk '{print $2}')
  if [ -z "$pid" ]; then
      echo "audit-service is not running"
      break
  else
      kill $pid
  fi
  sleep 10
done

pid=$(ps aux | grep "audit-service" | grep -v "grep" | awk '{print $2}')
if [ -z "$pid" ]; then
    echo "audit-service has stopped"
else
    kill -9 $pid
fi

echo "Stop audit-service successfully."
