/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.agent.plugin;

import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.state.AbstractStateWrapper;

import java.io.IOException;

/**
 * Instance interface, which generated by task in condition.
 */
public abstract class Instance extends AbstractStateWrapper {

    /**
     * init instance by instance profile
     *
     * @throws IOException
     */
    public abstract void init(Object instanceManager, InstanceProfile profile);

    /**
     * destroy instance.
     */
    public abstract void destroy();

    /**
     * get instance profile
     */
    public abstract InstanceProfile getProfile();

    /**
     * get task id
     */
    public abstract String getTaskId();

    /**
     * get instance id
     */
    public abstract String getInstanceId();
}
