/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task.file;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryManager.class);
    private static volatile MemoryManager memoryManager = null;
    private final AgentConfiguration conf;
    private ConcurrentHashMap<String, Semaphore> semaphoreMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lastPrintTime = new ConcurrentHashMap();
    private static final int PRINT_INTERVAL_MS = 1000;

    private MemoryManager() {
        this.conf = AgentConfiguration.getAgentConf();
        Semaphore semaphore = null;
        semaphore = new Semaphore(this.conf.getInt("agent.global.reader.source.permit", 16000000));
        this.semaphoreMap.put("agent.global.reader.source.permit", semaphore);
        this.lastPrintTime.put("agent.global.reader.source.permit", 0L);
        semaphore = new Semaphore(this.conf.getInt("agent.global.reader.queue.permit", 16000000));
        this.semaphoreMap.put("agent.global.reader.queue.permit", semaphore);
        this.lastPrintTime.put("agent.global.reader.queue.permit", 0L);
        semaphore = new Semaphore(this.conf.getInt("agent.global.writer.permit", 96000000));
        this.semaphoreMap.put("agent.global.writer.permit", semaphore);
        this.lastPrintTime.put("agent.global.writer.permit", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemoryManager getInstance() {
        if (memoryManager != null) return memoryManager;
        Class<MemoryManager> clazz = MemoryManager.class;
        synchronized (MemoryManager.class) {
            if (memoryManager != null) return memoryManager;
            memoryManager = new MemoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return memoryManager;
        }
    }

    public boolean tryAcquire(String semaphoreName, int permit) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("tryAcquire {} not exist");
            return false;
        }
        return semaphore.tryAcquire(permit);
    }

    public void release(String semaphoreName, int permit) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("release {} not exist");
            return;
        }
        semaphore.release(permit);
    }

    public int getLeft(String semaphoreName) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("getLeft {} not exist");
            return -1;
        }
        return semaphore.availablePermits();
    }

    public void printDetail(String semaphoreName, String detail) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("printDetail {} not exist", (Object)semaphoreName);
            return;
        }
        if (AgentUtils.getCurrentTime() - this.lastPrintTime.get(semaphoreName) > 1000L) {
            LOGGER.info("{} permit left {} wait {} {}", new Object[]{detail, semaphore.availablePermits(), semaphore.getQueueLength(), semaphoreName});
            this.lastPrintTime.put(semaphoreName, AgentUtils.getCurrentTime());
        }
    }

    public void printAll() {
        this.printDetail("agent.global.reader.source.permit", "printAll");
        this.printDetail("agent.global.reader.queue.permit", "printAll");
        this.printDetail("agent.global.writer.permit", "printAll");
    }
}

