/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.core.task.Task;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.message.EndMessage;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.state.AbstractStateWrapper;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskWrapper
extends AbstractStateWrapper {
    public static final int WAIT_FINISH_TIME_OUT = 1;
    public static final int WAIT_BEGIN_TIME_SECONDS = 60;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskWrapper.class);
    private final TaskManager taskManager;
    private final Task task;
    private final AtomicInteger retryTime = new AtomicInteger(0);
    private final int maxRetryTime;
    private final int pushMaxWaitTime;
    private final int pullMaxWaitTime;
    private ExecutorService executorService;

    public TaskWrapper(TaskManager manager, Task task) {
        this.taskManager = manager;
        this.task = task;
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        this.maxRetryTime = conf.getInt("task.maxRetry.time", 3);
        this.pushMaxWaitTime = conf.getInt("task.push.maxSecond", 2);
        this.pullMaxWaitTime = conf.getInt("task.pull.maxSecond", 2);
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("task-reader-writer-task_" + task.getTaskId()));
        }
        this.doChangeState(State.ACCEPTED);
    }

    private CompletableFuture<?> submitReadThread() {
        return CompletableFuture.runAsync(() -> {
            Message message = null;
            while (!this.isException() && !this.task.isReadFinished()) {
                if (!this.task.getReader().isSourceExist()) {
                    this.doChangeState(State.FAILED);
                    continue;
                }
                if (message != null && !this.task.getChannel().push(message, (long)this.pushMaxWaitTime, TimeUnit.SECONDS)) continue;
                message = this.task.getReader().read();
            }
            LOGGER.info("read end, task exception status is {}, read finish status is {}", (Object)this.isException(), (Object)this.task.isReadFinished());
            this.task.getChannel().push((Message)new EndMessage());
            this.task.getReader().destroy();
        }, this.executorService);
    }

    private CompletableFuture<?> submitWriteThread() {
        return CompletableFuture.runAsync(() -> {
            Message message;
            while (!this.isException() && !((message = this.task.getChannel().pull((long)this.pullMaxWaitTime, TimeUnit.SECONDS)) instanceof EndMessage)) {
                this.task.getSink().write(message);
            }
        }, this.executorService);
    }

    private void submitThreadsAndWait() {
        CompletableFuture<?> reader = this.submitReadThread();
        CompletableFuture<?> writer = this.submitWriteThread();
        ((CompletableFuture)CompletableFuture.allOf(reader, writer).exceptionally(ex -> {
            this.doChangeState(State.FAILED);
            LOGGER.error("exception caught", ex);
            return null;
        })).join();
    }

    void kill() {
        LOGGER.info("task id {} is killed", (Object)this.task.getTaskId());
        this.doChangeState(State.KILLED);
    }

    void waitForFinish() {
        LOGGER.info("set readTime out to 1 minute task id is {}", (Object)this.task.getTaskId());
        this.task.getReader().setReadTimeout(TimeUnit.MINUTES.toMillis(1L));
    }

    void destroyTask() {
        LOGGER.info("destroy task id is {}", (Object)this.task.getTaskId());
        this.task.getReader().finishRead();
    }

    boolean shouldRetry() {
        return this.retryTime.get() < this.maxRetryTime;
    }

    Task getTask() {
        return this.task;
    }

    public void addCallbacks() {
        this.addCallback(State.ACCEPTED, State.RUNNING, (before, after) -> {}).addCallback(State.RUNNING, State.FAILED, (before, after) -> {
            LOGGER.info("task {} is failed, please check it", (Object)this.task.getTaskId());
            this.retryTime.incrementAndGet();
            if (!this.shouldRetry()) {
                this.doChangeState(State.FATAL);
                this.taskManager.getTaskMetrics().taskFatalCount.incrementAndGet();
            }
        }).addCallback(State.FAILED, State.FATAL, (before, after) -> {}).addCallback(State.FAILED, State.ACCEPTED, (before, after) -> {}).addCallback(State.FAILED, State.RUNNING, (before, after) -> {}).addCallback(State.RUNNING, State.SUCCEEDED, (before, after) -> {});
    }

    public void run() {
        try {
            AgentThreadFactory.nameThread((String)this.task.getTaskId());
            LOGGER.info("start to run {}, retry time is {}", (Object)this.task.getTaskId(), (Object)this.retryTime.get());
            AgentUtils.silenceSleepInSeconds((long)this.task.getJobConf().getLong("job.taskWaitSeconds", 60L));
            this.doChangeState(State.RUNNING);
            this.task.init();
            this.submitThreadsAndWait();
            if (!this.isException()) {
                this.doChangeState(State.SUCCEEDED);
            }
            LOGGER.info("task state is {}, start to destroy task {}", (Object)this.getCurrentState(), (Object)this.task.getTaskId());
            this.task.destroy();
        }
        catch (Exception ex) {
            LOGGER.error("error while running wrapper", (Throwable)ex);
            this.doChangeState(State.FAILED);
        }
    }
}

