/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.Channel;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.Sink;

public class Task {
    private final String taskId;
    private final Reader reader;
    private final Sink sink;
    private final Channel channel;
    private final JobProfile jobConf;
    private volatile boolean isInited = false;

    public Task(String taskId, Reader reader, Sink sink, Channel channel, JobProfile jobConf) {
        this.reader = reader;
        this.sink = sink;
        this.taskId = taskId;
        this.channel = channel;
        this.jobConf = jobConf;
    }

    public boolean isReadFinished() {
        return this.reader.isFinished();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Sink getSink() {
        return this.sink;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public JobProfile getJobConf() {
        return this.jobConf;
    }

    public String getName() {
        return this.reader.getReadSource() + "->" + this.sink.toString();
    }

    public void init() {
        this.channel.init(this.jobConf);
        this.sink.init(this.jobConf);
        this.reader.init(this.jobConf);
        this.isInited = true;
    }

    public boolean isTaskFinishInit() {
        return this.isInited;
    }

    public void destroy() {
        this.reader.destroy();
        this.sink.destroy();
        this.channel.destroy();
    }
}

