/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.util.List;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.InstanceDb;
import org.apache.inlong.agent.db.OffsetDb;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetManager.class);
    public static final int CORE_THREAD_SLEEP_TIME = 60000;
    private static volatile OffsetManager offsetManager = null;
    private final OffsetDb offsetDb;
    private final InstanceDb instanceDb;

    private OffsetManager(Db offsetBasicDb, Db instanceBasicDb) {
        this.offsetDb = new OffsetDb(offsetBasicDb);
        this.instanceDb = new InstanceDb(instanceBasicDb);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("offset-manager-core");
            while (this.isRunnable()) {
                try {
                    AgentUtils.silenceSleepInMs((long)60000L);
                    List offsets = this.offsetDb.listAllOffsets();
                    offsets.forEach(offset -> {
                        String instanceId;
                        String taskId = offset.getTaskId();
                        InstanceProfile instanceProfile = this.instanceDb.getInstance(taskId, instanceId = offset.getInstanceId());
                        if (instanceProfile == null) {
                            this.deleteOffset(taskId, instanceId);
                            LOGGER.info("instance not found, delete offset taskId {} instanceId {}", (Object)taskId, (Object)instanceId);
                        }
                    });
                    LOGGER.info("offsetManager running! offsets count {}", (Object)offsets.size());
                }
                catch (Throwable ex) {
                    LOGGER.error("offset-manager-core: ", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Db offsetBasicDb, Db instanceBasicDb) {
        if (offsetManager != null) return;
        Class<OffsetManager> clazz = OffsetManager.class;
        synchronized (OffsetManager.class) {
            if (offsetManager != null) return;
            offsetManager = new OffsetManager(offsetBasicDb, instanceBasicDb);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static OffsetManager getInstance() {
        if (offsetManager == null) {
            throw new RuntimeException("task position manager has not been initialized by agentManager");
        }
        return offsetManager;
    }

    public void setOffset(OffsetProfile profile) {
        this.offsetDb.setOffset(profile);
    }

    public void deleteOffset(String taskId, String instanceId) {
        this.offsetDb.deleteOffset(taskId, instanceId);
    }

    public OffsetProfile getOffset(String taskId, String instanceId) {
        return this.offsetDb.getOffset(taskId, instanceId);
    }

    public void start() throws Exception {
        this.submitWorker(this.coreThread());
    }

    public void stop() throws Exception {
    }
}

