/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchConfig;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchApi {
    private static final String FIELD_KEY = "properties";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchApi.class);
    @Autowired
    private ElasticsearchConfig esConfig;

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws IOException {
        LOG.info("get es search request of {}", (Object)searchRequest.source().toString());
        return this.getEsClient().search(searchRequest, options);
    }

    public boolean indexExists(String indexName) throws IOException {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(new String[]{indexName});
        return this.getEsClient().indices().exists(getIndexRequest, RequestOptions.DEFAULT);
    }

    public void createIndex(String indexName) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        CreateIndexResponse createIndexResponse = this.getEsClient().indices().create(createIndexRequest, RequestOptions.DEFAULT);
        LOG.info("create es index:{} result: {}", (Object)indexName, (Object)createIndexResponse.isAcknowledged());
    }

    private List<String> getMappingInfo(List<ElasticsearchFieldInfo> fieldsInfo) {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (ElasticsearchFieldInfo field : fieldsInfo) {
            StringBuilder fieldStr = new StringBuilder().append("        \"").append(field.getFieldName()).append("\" : {\n          \"type\" : \"").append(field.getFieldType()).append("\"");
            if (field.getFieldType().equals("text")) {
                if (StringUtils.isNotEmpty((CharSequence)field.getAnalyzer())) {
                    fieldStr.append(",\n          \"analyzer\" : \"").append(field.getAnalyzer()).append("\"");
                }
                if (StringUtils.isNotEmpty((CharSequence)field.getSearchAnalyzer())) {
                    fieldStr.append(",\n          \"search_analyzer\" : \"").append(field.getSearchAnalyzer()).append("\"");
                }
            } else if (field.getFieldType().equals("date")) {
                if (StringUtils.isNotEmpty((CharSequence)field.getFieldFormat())) {
                    fieldStr.append(",\n          \"format\" : \"").append(field.getFieldFormat()).append("\"");
                }
            } else if (field.getFieldType().equals("scaled_float") && StringUtils.isNotEmpty((CharSequence)field.getScalingFactor())) {
                fieldStr.append(",\n          \"scaling_factor\" : \"").append(field.getScalingFactor()).append("\"");
            }
            fieldStr.append("\n        }");
            fieldList.add(fieldStr.toString());
        }
        return fieldList;
    }

    public void createIndexAndMapping(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        List<String> fieldList = this.getMappingInfo(fieldInfos);
        StringBuilder mapping = new StringBuilder().append("{\n      \"properties\" : {\n").append(StringUtils.join(fieldList, (String)",\n")).append("\n      }\n}");
        createIndexRequest.mapping(mapping.toString(), XContentType.JSON);
        CreateIndexResponse createIndexResponse = this.getEsClient().indices().create(createIndexRequest, RequestOptions.DEFAULT);
        LOG.info("create {}:{}", (Object)indexName, (Object)createIndexResponse.isAcknowledged());
    }

    public Map<String, MappingMetaData> getFields(String indexName) throws IOException {
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexName});
        return this.getEsClient().indices().getMapping(request, RequestOptions.DEFAULT).mappings();
    }

    public void addFields(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws IOException {
        if (CollectionUtils.isNotEmpty(fieldInfos)) {
            List<String> fieldList = this.getMappingInfo(fieldInfos);
            StringBuilder mapping = new StringBuilder().append("{\n      \"properties\" : {\n").append(StringUtils.join(fieldList, (String)",\n")).append("\n      }\n}");
            System.out.println(mapping.toString());
            PutMappingRequest indexRequest = new PutMappingRequest(new String[]{indexName}).source(mapping.toString(), XContentType.JSON);
            AcknowledgedResponse acknowledgedResponse = this.getEsClient().indices().putMapping(indexRequest, RequestOptions.DEFAULT);
            LOG.info("put mapping: {} result: {}", (Object)mapping.toString(), (Object)acknowledgedResponse.toString());
        }
    }

    public void addNotExistFields(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws IOException {
        ArrayList<ElasticsearchFieldInfo> notExistFieldInfos = new ArrayList<ElasticsearchFieldInfo>(fieldInfos);
        Map<String, MappingMetaData> mapping = this.getFields(indexName);
        Map filedMap = (Map)mapping.get(indexName).getSourceAsMap().get(FIELD_KEY);
        block0: for (String key : filedMap.keySet()) {
            for (ElasticsearchFieldInfo field : notExistFieldInfos) {
                if (!field.getFieldName().equals(key)) continue;
                notExistFieldInfos.remove(field);
                continue block0;
            }
        }
        this.addFields(indexName, notExistFieldInfos);
    }

    public RestHighLevelClient getEsClient() {
        return this.esConfig.highLevelClient();
    }

    public void setEsConfig(ElasticsearchConfig config) {
        this.esConfig = config;
    }
}

