/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.ck;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.dao.entity.AuditSourceEntity;
import org.apache.inlong.manager.dao.mapper.AuditSourceEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseConfig {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConfig.class);
    @Autowired
    private AuditSourceEntityMapper auditSourceMapper;
    private static volatile DataSource source;
    private static volatile String currentJdbcUrl;
    private static volatile String currentUsername;
    private static volatile String currentPassword;

    public synchronized void updateRuntimeConfig() {
        try {
            boolean changed;
            AuditSourceEntity auditSource = this.auditSourceMapper.selectOnlineSource();
            String jdbcUrl = auditSource.getUrl();
            String username = auditSource.getUsername();
            String password = StringUtils.isBlank((String)auditSource.getToken()) ? "" : auditSource.getToken();
            boolean bl = changed = !Objects.equals(currentJdbcUrl, jdbcUrl) || !Objects.equals(currentUsername, username) || !Objects.equals(currentPassword, password);
            if (changed) {
                currentJdbcUrl = jdbcUrl;
                currentUsername = username;
                currentPassword = password;
                Properties pros = new Properties();
                pros.put("url", jdbcUrl);
                if (StringUtils.isNotBlank((String)username)) {
                    pros.put("username", username);
                }
                if (StringUtils.isNotBlank((String)password)) {
                    pros.put("password", password);
                }
                source = DruidDataSourceFactory.createDataSource((Properties)pros);
                log.info("success to create connection to {}", (Object)jdbcUrl);
            }
        }
        catch (Exception e) {
            log.error("failed to read click house audit source: ", (Throwable)e);
        }
    }

    public Connection getCkConnection() throws Exception {
        log.debug("start to get connection for CLICKHOUSE");
        for (int retry = 0; source == null && retry < 3; ++retry) {
            this.updateRuntimeConfig();
        }
        if (source == null) {
            log.warn("jdbc source is null for CLICKHOUSE");
            return null;
        }
        Connection connection = source.getConnection();
        log.info("success to get connection for CLICKHOUSE");
        return connection;
    }

    static {
        currentJdbcUrl = null;
        currentUsername = null;
        currentPassword = null;
    }
}

