/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.SinkType;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractStandaloneSinkResourceOperator
implements SinkResourceOperator {
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private InlongGroupEntityMapper groupEntityMapper;
    @Autowired
    private StreamSinkService sinkService;
    private static final String SORT_PREFIX = "SORT_";
    private Random rand = new Random();

    @VisibleForTesting
    protected void assignCluster(SinkInfo sinkInfo) {
        if (StringUtils.isNotBlank((CharSequence)sinkInfo.getInlongClusterName())) {
            String info = "success to create es resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            return;
        }
        String targetCluster = this.assignOneCluster(sinkInfo);
        Preconditions.expectNotBlank((String)targetCluster, (String)String.format("find no proper cluster assign to group=%s, stream=%s, sink type=%s, data node=%s ", sinkInfo.getInlongGroupId(), sinkInfo.getInlongStreamId(), sinkInfo.getSinkType(), sinkInfo.getDataNodeName()));
        StreamSinkEntity sink = this.sinkEntityMapper.selectByPrimaryKey(sinkInfo.getId());
        sink.setInlongClusterName(targetCluster);
        sink.setStatus(SinkStatus.CONFIG_SUCCESSFUL.getCode());
        this.sinkEntityMapper.updateByIdSelective(sink);
    }

    private String assignOneCluster(SinkInfo sinkInfo) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.assignFromExist(sinkInfo.getDataNodeName()), this.assignFromRelated(sinkInfo.getSinkType(), sinkInfo.getInlongGroupId())});
    }

    private String assignFromExist(String dataNodeName) {
        return this.sinkEntityMapper.selectAssignedCluster(dataNodeName);
    }

    private String assignFromRelated(String sinkType, String groupId) {
        InlongGroupEntity group = this.groupEntityMapper.selectByGroupId(groupId);
        String sortClusterType = SinkType.relatedSortClusterType((String)sinkType);
        List clusters = this.clusterEntityMapper.selectByKey(null, null, sortClusterType).stream().filter(cluster -> this.checkCluster(cluster.getClusterTags(), group.getInlongClusterTag())).collect(Collectors.toList());
        return CollectionUtils.isEmpty(clusters) ? null : ((InlongClusterEntity)clusters.get(this.rand.nextInt(clusters.size()))).getName();
    }

    private boolean checkCluster(String clusterTags, String targetTag) {
        return StringUtils.isBlank((CharSequence)clusterTags) || Sets.newHashSet((Object[])clusterTags.split(",")).contains(targetTag);
    }
}

