/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.kafka;

import com.google.common.annotations.VisibleForTesting;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.cluster.InlongClusterServiceImpl;
import org.apache.inlong.manager.service.message.DeserializeOperator;
import org.apache.inlong.manager.service.message.DeserializeOperatorFactory;
import org.apache.inlong.manager.service.resource.queue.kafka.KafkaUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KafkaOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongClusterServiceImpl.class);
    @Autowired
    public DeserializeOperatorFactory deserializeOperatorFactory;

    public void createTopic(InlongKafkaInfo inlongKafkaInfo, KafkaClusterInfo kafkaClusterInfo, String topicName) throws InterruptedException, ExecutionException {
        AdminClient adminClient = KafkaUtils.getAdminClient(kafkaClusterInfo);
        NewTopic topic = new NewTopic(topicName, inlongKafkaInfo.getNumPartitions().intValue(), inlongKafkaInfo.getReplicationFactor().shortValue());
        if (this.topicIsExists(kafkaClusterInfo, topicName)) {
            LOGGER.warn("kafka topic={} already exists", (Object)topicName);
            return;
        }
        CreateTopicsResult result = adminClient.createTopics(Collections.singletonList(topic));
        Thread.sleep(500L);
        LOGGER.info("success to create kafka topic={}, with={} numPartitions", (Object)topicName, result.numPartitions(topicName).get());
    }

    public void forceDeleteTopic(KafkaClusterInfo kafkaClusterInfo, String topicName) {
        AdminClient adminClient = KafkaUtils.getAdminClient(kafkaClusterInfo);
        DeleteTopicsResult result = adminClient.deleteTopics(Collections.singletonList(topicName));
        LOGGER.info("success to delete topic={}, result: {}", (Object)topicName, (Object)result.all());
    }

    public boolean topicIsExists(KafkaClusterInfo kafkaClusterInfo, String topic) throws ExecutionException, InterruptedException {
        AdminClient adminClient = KafkaUtils.getAdminClient(kafkaClusterInfo);
        Set topicList = (Set)adminClient.listTopics().names().get();
        return topicList.contains(topic);
    }

    public List<BriefMQMessage> queryLatestMessage(KafkaClusterInfo clusterInfo, String topicName, String consumeGroup, Integer messageCount, InlongStreamInfo streamInfo) {
        LOGGER.debug("begin to query message for topic {} in cluster: {}", (Object)topicName, (Object)clusterInfo);
        Properties properties = KafkaOperator.getProperties(clusterInfo.getUrl(), consumeGroup);
        KafkaConsumer consumer = new KafkaConsumer(properties);
        return this.getLatestMessage((Consumer<byte[], byte[]>)consumer, topicName, messageCount, streamInfo);
    }

    @VisibleForTesting
    public List<BriefMQMessage> getLatestMessage(Consumer<byte[], byte[]> consumer, String topicName, Integer messageCount, InlongStreamInfo streamInfo) {
        ArrayList<BriefMQMessage> messageList = new ArrayList<BriefMQMessage>();
        try {
            List partitionInfoList = consumer.partitionsFor(topicName);
            List topicPartitionList = partitionInfoList.stream().map(topicPartition -> new TopicPartition(topicPartition.topic(), topicPartition.partition())).collect(Collectors.toList());
            Map beginningTopicPartitionList = consumer.beginningOffsets(topicPartitionList);
            Map endTopicPartitionList = consumer.endOffsets(topicPartitionList);
            int count = (int)Math.ceil((double)messageCount.intValue() / (double)topicPartitionList.size());
            Map<TopicPartition, Long> expectedOffsetMap = beginningTopicPartitionList.entrySet().stream().map(entry -> {
                long beginningOffset = (Long)entry.getValue();
                long endOffset = endTopicPartitionList.getOrDefault(entry.getKey(), beginningOffset);
                Long offset = endOffset - beginningOffset >= (long)count ? endOffset - (long)count : beginningOffset;
                return Pair.of(entry.getKey(), (Object)offset);
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            consumer.assign(topicPartitionList);
            expectedOffsetMap.forEach((arg_0, arg_1) -> consumer.seek(arg_0, arg_1));
            int index = 0;
            ConsumerRecords records = consumer.poll(Duration.ofMillis(100L));
            for (ConsumerRecord record : records) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header header : record.headers()) {
                    headers.put(header.key(), new String(header.value(), StandardCharsets.UTF_8));
                }
                int wrapTypeId = Integer.parseInt(headers.getOrDefault("msgEnType", Integer.toString(MessageWrapType.INLONG_MSG_V0.getId())));
                DeserializeOperator deserializeOperator = this.deserializeOperatorFactory.getInstance(MessageWrapType.valueOf((int)wrapTypeId));
                messageList.addAll(deserializeOperator.decodeMsg(streamInfo, (byte[])record.value(), headers, index));
                if (messageList.size() < messageCount) continue;
                break;
            }
        }
        catch (Exception e) {
            String errMsg = "decode msg error: ";
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg + e.getMessage());
        }
        finally {
            consumer.close();
        }
        LOGGER.debug("success query messages for topic={}, size={}, returned size={}", new Object[]{topicName, messageList.size(), messageCount});
        int fromIndex = messageList.size() > messageCount ? messageList.size() - messageCount : 0;
        List<BriefMQMessage> resultList = messageList.subList(fromIndex, messageList.size());
        for (int i = 0; i < resultList.size(); ++i) {
            BriefMQMessage message = resultList.get(i);
            message.setId(Integer.valueOf(i + 1));
        }
        return resultList;
    }

    private static Properties getProperties(String clusterUrl, String consumeGroup) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", clusterUrl);
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("group.id", consumeGroup);
        return properties;
    }
}

