/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.repository;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterObject;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterSetObject;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.common.pojo.dataproxy.IRepository;
import org.apache.inlong.common.pojo.dataproxy.InLongIdObject;
import org.apache.inlong.common.pojo.dataproxy.ProxyClusterObject;
import org.apache.inlong.common.pojo.dataproxy.RepositoryTimerTask;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.ClusterSetMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.dataproxy.CacheCluster;
import org.apache.inlong.manager.pojo.dataproxy.InlongGroupId;
import org.apache.inlong.manager.pojo.dataproxy.InlongStreamId;
import org.apache.inlong.manager.pojo.dataproxy.ProxyCluster;
import org.apache.inlong.manager.pojo.sink.SinkPageRequest;
import org.apache.inlong.manager.service.core.SortConfigLoader;
import org.apache.inlong.manager.service.repository.DataProxyConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Lazy
@Repository(value="dataProxyConfigRepositoryV2")
public class DataProxyConfigRepositoryV2
implements IRepository {
    public static final Logger LOGGER = LoggerFactory.getLogger(DataProxyConfigRepositoryV2.class);
    public static final String KEY_NAMESPACE = "namespace";
    public static final String KEY_BACKUP_CLUSTER_TAG = "backup_cluster_tag";
    public static final String KEY_BACKUP_TOPIC = "backup_topic";
    public static final String KEY_DATA_TYPE = "dataType";
    public static final String KEY_SORT_TASK_NAME = "defaultSortTaskName";
    public static final String KEY_DATA_NODE_NAME = "defaultDataNodeName";
    public static final String KEY_SORT_CONSUMER_GROUP = "defaultSortConsumerGroup";
    public static final String KEY_SINK_NAME = "defaultSinkName";
    public static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    public static final String CACHE_CLUSTER_PRODUCER_TAG = "producer";
    public static final String CACHE_CLUSTER_CONSUMER_TAG = "consumer";
    private static final Gson GSON = new Gson();
    private Map<String, String> proxyConfigJson = new ConcurrentHashMap<String, String>();
    private Map<String, String> proxyMd5Map = new ConcurrentHashMap<String, String>();
    private long reloadInterval;
    @Autowired
    private ClusterSetMapper clusterSetMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private InlongGroupEntityMapper inlongGroupMapper;
    @Autowired
    private StreamSinkEntityMapper streamSinkMapper;
    @Autowired
    private SortConfigLoader sortConfigLoader;

    @PostConstruct
    public void initialize() {
        LOGGER.info("create repository for " + DataProxyConfigRepository.class.getSimpleName());
        try {
            this.reloadInterval = 60000L;
            this.reload();
            this.setReloadTimer();
        }
        catch (Throwable t) {
            LOGGER.error("Initialize DataProxyConfigRepository error", t);
        }
    }

    public ClusterSetMapper getClusterSetMapper() {
        return this.clusterSetMapper;
    }

    public void setClusterSetMapper(ClusterSetMapper clusterSetMapper) {
        this.clusterSetMapper = clusterSetMapper;
    }

    public InlongClusterEntityMapper getClusterMapper() {
        return this.clusterMapper;
    }

    public void setClusterMapper(InlongClusterEntityMapper clusterMapper) {
        this.clusterMapper = clusterMapper;
    }

    public InlongGroupEntityMapper getInlongGroupMapper() {
        return this.inlongGroupMapper;
    }

    public void setInlongGroupMapper(InlongGroupEntityMapper inlongGroupMapper) {
        this.inlongGroupMapper = inlongGroupMapper;
    }

    public StreamSinkEntityMapper getStreamSinkMapper() {
        return this.streamSinkMapper;
    }

    public void setStreamSinkMapper(StreamSinkEntityMapper streamSinkMapper) {
        this.streamSinkMapper = streamSinkMapper;
    }

    @Transactional(rollbackFor={Exception.class})
    public void reload() {
        LOGGER.info("start to reload config:" + this.getClass().getSimpleName());
        HashMap<String, DataProxyCluster> proxyClusterMap = new HashMap<String, DataProxyCluster>();
        this.reloadProxyCluster(proxyClusterMap);
        if (proxyClusterMap.size() == 0) {
            return;
        }
        this.reloadCacheCluster(proxyClusterMap);
        this.reloadInlongId(proxyClusterMap);
        this.generateClusterJson(proxyClusterMap);
        LOGGER.info("end to reload config:" + this.getClass().getSimpleName());
    }

    private void reloadProxyCluster(Map<String, DataProxyCluster> proxyClusterMap) {
        for (ProxyCluster proxyCluster : this.clusterSetMapper.selectProxyCluster()) {
            ProxyClusterObject obj = new ProxyClusterObject();
            obj.setName(proxyCluster.getClusterName());
            obj.setSetName(proxyCluster.getClusterTag());
            obj.setZone(proxyCluster.getExtTag());
            DataProxyCluster clusterObj = new DataProxyCluster();
            clusterObj.setProxyCluster(obj);
            proxyClusterMap.put(obj.getName(), clusterObj);
        }
    }

    private void reloadCacheCluster(Map<String, DataProxyCluster> proxyClusterMap) {
        HashMap cacheClusterMap = new HashMap();
        for (CacheCluster cacheCluster : this.clusterSetMapper.selectCacheCluster()) {
            Map tagMap;
            String producerTag;
            if (StringUtils.isEmpty((CharSequence)cacheCluster.getExtTag()) || !StringUtils.equalsIgnoreCase((CharSequence)(producerTag = (tagMap = MAP_SPLITTER.split((CharSequence)cacheCluster.getExtTag())).getOrDefault(CACHE_CLUSTER_PRODUCER_TAG, Boolean.TRUE.toString())), (CharSequence)Boolean.TRUE.toString()) || !StringUtils.isNotBlank((CharSequence)cacheCluster.getClusterTags())) continue;
            HashSet clusterTags = Sets.newHashSet((Object[])cacheCluster.getClusterTags().split(","));
            clusterTags.forEach(clusterTag -> cacheClusterMap.computeIfAbsent(clusterTag, k -> new HashMap()).computeIfAbsent(cacheCluster.getExtTag(), k -> new ArrayList()).add(cacheCluster));
        }
        HashMap<String, Map> tagCache = new HashMap<String, Map>();
        for (Map.Entry<String, DataProxyCluster> entry : proxyClusterMap.entrySet()) {
            Map cacheClusterZoneMap;
            DataProxyCluster clusterObj = entry.getValue();
            ProxyClusterObject proxyObj = clusterObj.getProxyCluster();
            String clusterTag2 = proxyObj.getSetName();
            String extTag = proxyObj.getZone();
            if (StringUtils.isEmpty((CharSequence)extTag) || (cacheClusterZoneMap = (Map)cacheClusterMap.get(clusterTag2)) == null) continue;
            Map subTagMap = tagCache.computeIfAbsent(extTag, k -> MAP_SPLITTER.split((CharSequence)extTag));
            for (Map.Entry cacheEntry : cacheClusterZoneMap.entrySet()) {
                Map wholeTagMap;
                if (((List)cacheEntry.getValue()).size() == 0 || !this.isSubTag(wholeTagMap = tagCache.computeIfAbsent((String)cacheEntry.getKey(), k -> MAP_SPLITTER.split((CharSequence)cacheEntry.getKey())), subTagMap)) continue;
                CacheClusterSetObject cacheSet = clusterObj.getCacheClusterSet();
                cacheSet.setSetName(clusterTag2);
                List cacheClusterList = (List)cacheEntry.getValue();
                cacheSet.setType(((CacheCluster)cacheClusterList.get(0)).getType());
                List cacheClusters = cacheSet.getCacheClusters();
                for (CacheCluster cacheCluster : cacheClusterList) {
                    CacheClusterObject obj = new CacheClusterObject();
                    obj.setName(cacheCluster.getClusterName());
                    obj.setZone(cacheCluster.getExtTag());
                    obj.setToken(cacheCluster.getToken());
                    obj.setParams(this.fromJsonToMap(cacheCluster.getExtParams()));
                    cacheClusters.add(obj);
                }
            }
        }
    }

    private Map<String, String> fromJsonToMap(String jsonString) {
        HashMap<String, String> mapObj = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return mapObj;
        }
        try {
            JsonObject obj = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            for (String key : obj.keySet()) {
                JsonElement child = obj.get(key);
                if (child.isJsonPrimitive()) {
                    mapObj.put(key, child.getAsString());
                    continue;
                }
                mapObj.put(key, child.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("parse json string to map error", (Throwable)e);
        }
        return mapObj;
    }

    private JsonObject fromJsonToJson(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return new JsonObject();
        }
        try {
            return (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
        }
        catch (Exception e) {
            LOGGER.error("parse json string to json object error", (Throwable)e);
            return new JsonObject();
        }
    }

    private void reloadInlongId(Map<String, DataProxyCluster> proxyClusterMap) {
        HashMap<String, InlongGroupId> groupIdMap = new HashMap<String, InlongGroupId>();
        this.clusterSetMapper.selectInlongGroupId().forEach(value -> groupIdMap.put(value.getInlongGroupId(), (InlongGroupId)value));
        HashMap<String, Map<String, String>> groupParams = new HashMap<String, Map<String, String>>();
        groupIdMap.forEach((k, v) -> groupParams.put((String)k, this.fromJsonToMap(v.getExtParams())));
        List<InlongGroupExtEntity> groupExtCursor = this.sortConfigLoader.loadGroupBackupInfo(KEY_BACKUP_CLUSTER_TAG);
        groupExtCursor.forEach(v -> groupParams.computeIfAbsent(v.getInlongGroupId(), k -> new HashMap()).put(KEY_BACKUP_CLUSTER_TAG, v.getKeyValue()));
        HashMap<String, InlongStreamId> streamIdMap = new HashMap<String, InlongStreamId>();
        this.clusterSetMapper.selectInlongStreamId().forEach(v -> streamIdMap.put(this.getInlongId(v.getInlongGroupId(), v.getInlongStreamId()), (InlongStreamId)v));
        HashMap<String, Map<String, String>> streamParams = new HashMap<String, Map<String, String>>();
        streamIdMap.forEach((k, v) -> {
            Map<String, String> params = this.fromJsonToMap(v.getExtParams());
            params.computeIfAbsent(KEY_DATA_TYPE, type -> v.getDataType());
            streamParams.put((String)k, params);
        });
        List<InlongStreamExtEntity> streamExtCursor = this.sortConfigLoader.loadStreamBackupInfo("backup_mq_resource");
        streamExtCursor.forEach(v -> streamParams.computeIfAbsent(this.getInlongId(v.getInlongGroupId(), v.getInlongStreamId()), k -> new HashMap()).put("backup_mq_resource", v.getKeyValue()));
        Map<String, List<InLongIdObject>> inlongIdMap = this.parseInlongId(groupIdMap, groupParams, streamIdMap, streamParams);
        for (Map.Entry<String, DataProxyCluster> entry : proxyClusterMap.entrySet()) {
            String clusterTag = entry.getValue().getProxyCluster().getSetName();
            List<InLongIdObject> inlongIds = inlongIdMap.get(clusterTag);
            if (inlongIds == null) continue;
            entry.getValue().getProxyCluster().getInlongIds().addAll(inlongIds);
        }
    }

    private Map<String, List<InLongIdObject>> parseInlongId(Map<String, InlongGroupId> groupIdMap, Map<String, Map<String, String>> groupParams, Map<String, InlongStreamId> streamIdMap, Map<String, Map<String, String>> streamParams) {
        HashMap<String, List<InLongIdObject>> inlongIdMap = new HashMap<String, List<InLongIdObject>>();
        for (Map.Entry<String, InlongStreamId> entry : streamIdMap.entrySet()) {
            InlongStreamId streamIdObj = entry.getValue();
            String groupId = streamIdObj.getInlongGroupId();
            InlongGroupId groupIdObj = groupIdMap.get(groupId);
            if (groupId == null || groupIdObj == null) {
                LOGGER.debug("groupId {} or groupIdObj {} is null, ignored", (Object)groupId, (Object)groupIdObj);
                continue;
            }
            InLongIdObject obj = new InLongIdObject();
            String inlongId = entry.getKey();
            obj.setInlongId(inlongId);
            Optional.ofNullable(groupParams.get(groupId)).ifPresent(v -> obj.getParams().putAll(v));
            Optional.ofNullable(streamParams.get(inlongId)).ifPresent(v -> obj.getParams().putAll(v));
            if (StringUtils.isBlank((CharSequence)streamIdObj.getTopic())) {
                obj.setTopic(groupIdObj.getTopic());
            } else {
                obj.setTopic(streamIdObj.getTopic());
                obj.getParams().put(KEY_NAMESPACE, groupIdObj.getTopic());
            }
            inlongIdMap.computeIfAbsent(groupIdObj.getClusterTag(), k -> new ArrayList()).add(obj);
            InLongIdObject backupObj = new InLongIdObject();
            backupObj.setInlongId(inlongId);
            backupObj.getParams().putAll(obj.getParams());
            Map<String, String> groupParam = groupParams.get(groupId);
            if (groupParam == null || !groupParam.containsKey(KEY_BACKUP_CLUSTER_TAG) || !groupParam.containsKey("backup_mq_resource")) continue;
            String clusterTag = groupParam.get(KEY_BACKUP_CLUSTER_TAG);
            String groupMqResource = groupParam.get("backup_mq_resource");
            Map<String, String> streamParam = streamParams.get(inlongId);
            if (streamParam != null && !StringUtils.isBlank((CharSequence)streamParam.get("backup_mq_resource"))) {
                backupObj.setTopic(streamParam.get("backup_mq_resource"));
                backupObj.getParams().put(KEY_NAMESPACE, groupMqResource);
            } else {
                backupObj.setTopic(groupMqResource);
            }
            inlongIdMap.computeIfAbsent(clusterTag, k -> new ArrayList()).add(backupObj);
        }
        return inlongIdMap;
    }

    private String getInlongId(String inlongGroupId, String inlongStreamId) {
        return inlongGroupId + "." + inlongStreamId;
    }

    private void setReloadTimer() {
        Timer reloadTimer = new Timer(true);
        RepositoryTimerTask task = new RepositoryTimerTask((IRepository)this);
        reloadTimer.scheduleAtFixedRate((TimerTask)task, this.reloadInterval, this.reloadInterval);
    }

    private void generateClusterJson(Map<String, DataProxyCluster> proxyClusterMap) {
        ConcurrentHashMap<String, String> newProxyConfigJson = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> newProxyMd5Map = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, DataProxyCluster> entry : proxyClusterMap.entrySet()) {
            DataProxyCluster proxyObj = entry.getValue();
            String jsonDataProxyCluster = GSON.toJson((Object)proxyObj);
            String md5 = DigestUtils.md5Hex((String)jsonDataProxyCluster);
            DataProxyConfigResponse response = new DataProxyConfigResponse();
            response.setResult(Boolean.valueOf(true));
            response.setErrCode(Integer.valueOf(0));
            response.setMd5(md5);
            response.setData(proxyObj);
            String jsonResponse = GSON.toJson((Object)response);
            newProxyConfigJson.put(entry.getKey(), jsonResponse);
            newProxyMd5Map.put(entry.getKey(), md5);
        }
        this.proxyConfigJson = newProxyConfigJson;
        this.proxyMd5Map = newProxyMd5Map;
    }

    private boolean isSubTag(Map<String, String> wholeTagMap, Map<String, String> subTagMap) {
        for (Map.Entry<String, String> entry : subTagMap.entrySet()) {
            String value = wholeTagMap.get(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String getProxyMd5(String clusterName) {
        return this.proxyMd5Map.get(clusterName);
    }

    public String getProxyConfigJson(String clusterName) {
        return this.proxyConfigJson.get(clusterName);
    }

    public String changeClusterTag(String inlongGroupId, String clusterTag, String topic) {
        try {
            InlongGroupEntity oldGroup = this.inlongGroupMapper.selectByGroupId(inlongGroupId);
            if (oldGroup == null) {
                throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
            }
            String oldClusterTag = oldGroup.getInlongClusterTag();
            if (StringUtils.equals((CharSequence)oldClusterTag, (CharSequence)clusterTag)) {
                return "Cluster tag is same.";
            }
            InlongGroupEntity newGroup = this.prepareClusterTagGroup(oldGroup, clusterTag, topic);
            HashMap clusterMap = new HashMap();
            ClusterPageRequest clusterRequest = new ClusterPageRequest();
            List clusters = this.clusterMapper.selectByCondition(clusterRequest);
            clusters.forEach(v -> clusterMap.put(v.getName(), v));
            SinkPageRequest request = new SinkPageRequest();
            request.setInlongGroupId(inlongGroupId);
            List streamSinks = this.streamSinkMapper.selectByCondition(request);
            ArrayList<StreamSinkEntity> newStreamSinks = new ArrayList<StreamSinkEntity>();
            for (StreamSinkEntity streamSink : streamSinks) {
                String clusterType;
                StreamSinkEntity newStreamSink;
                String clusterName = streamSink.getInlongClusterName();
                InlongClusterEntity cluster = (InlongClusterEntity)clusterMap.get(clusterName);
                if (cluster == null || !StringUtils.equals((CharSequence)oldClusterTag, (CharSequence)cluster.getClusterTags()) || (newStreamSink = this.createNewStreamSink(clusters, clusterType = cluster.getType(), clusterTag, streamSink)) == null) continue;
                newStreamSinks.add(newStreamSink);
            }
            newStreamSinks.forEach(v -> this.streamSinkMapper.insert(v));
            int rowCount = this.inlongGroupMapper.updateByIdentifierSelective(newGroup);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("inlong group has already updated with group id={}, curVersion={}", (Object)newGroup.getInlongGroupId(), (Object)newGroup.getVersion());
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
            return inlongGroupId;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    private StreamSinkEntity createNewStreamSink(List<InlongClusterEntity> clusters, String clusterType, String clusterTag, StreamSinkEntity srcStreamSink) {
        for (InlongClusterEntity v : clusters) {
            if (!StringUtils.equals((CharSequence)clusterType, (CharSequence)v.getType()) || !StringUtils.equals((CharSequence)clusterTag, (CharSequence)v.getClusterTags())) continue;
            String newExtParams = v.getExtParams();
            JsonObject extParams = this.fromJsonToJson(newExtParams);
            if (extParams.has(KEY_SINK_NAME) && extParams.has(KEY_SORT_TASK_NAME) && extParams.has(KEY_DATA_NODE_NAME) && extParams.has(KEY_SORT_CONSUMER_GROUP)) {
                String sinkName = extParams.get(KEY_SINK_NAME).getAsString();
                String sortTaskName = extParams.get(KEY_SORT_TASK_NAME).getAsString();
                String dataNodeName = extParams.get(KEY_DATA_NODE_NAME).getAsString();
                String sortConsumerGroup = extParams.get(KEY_SORT_CONSUMER_GROUP).getAsString();
                StreamSinkEntity newStreamSink = this.copyStreamSink(srcStreamSink);
                newStreamSink.setInlongClusterName(v.getName());
                newStreamSink.setSinkName(sinkName);
                newStreamSink.setSortTaskName(sortTaskName);
                newStreamSink.setDataNodeName(dataNodeName);
                newStreamSink.setSortConsumerGroup(sortConsumerGroup);
                return newStreamSink;
            }
            return null;
        }
        return null;
    }

    private StreamSinkEntity copyStreamSink(StreamSinkEntity streamSink) {
        StreamSinkEntity streamSinkDest = new StreamSinkEntity();
        CommonBeanUtils.copyProperties((Object)streamSink, (Object)streamSinkDest);
        streamSinkDest.setId(null);
        streamSinkDest.setModifyTime(new Date());
        return streamSinkDest;
    }

    private InlongGroupEntity prepareClusterTagGroup(InlongGroupEntity oldGroup, String clusterTag, String topic) throws IllegalAccessException, InvocationTargetException {
        String extParams = oldGroup.getExtParams();
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            extParams = "{}";
        }
        JsonObject extParamsObj = this.fromJsonToJson(extParams);
        extParamsObj.addProperty(KEY_BACKUP_CLUSTER_TAG, oldGroup.getInlongClusterTag());
        extParamsObj.addProperty(KEY_BACKUP_TOPIC, oldGroup.getMqResource());
        InlongGroupEntity newGroup = new InlongGroupEntity();
        BeanUtils.copyProperties((Object)newGroup, (Object)oldGroup);
        newGroup.setId(null);
        newGroup.setInlongClusterTag(clusterTag);
        newGroup.setMqResource(topic);
        String newExtParams = extParamsObj.toString();
        newGroup.setExtParams(newExtParams);
        return newGroup;
    }

    public String removeBackupClusterTag(String inlongGroupId) {
        InlongGroupEntity oldGroup = this.inlongGroupMapper.selectByGroupId(inlongGroupId);
        if (oldGroup == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        String extParams = oldGroup.getExtParams();
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            return inlongGroupId;
        }
        JsonObject extParamsObj = this.fromJsonToJson(extParams);
        if (!extParamsObj.has(KEY_BACKUP_CLUSTER_TAG)) {
            return inlongGroupId;
        }
        String oldClusterTag = extParamsObj.get(KEY_BACKUP_CLUSTER_TAG).getAsString();
        extParamsObj.remove(KEY_BACKUP_CLUSTER_TAG);
        extParamsObj.remove(KEY_BACKUP_TOPIC);
        String newExtParams = extParamsObj.toString();
        oldGroup.setExtParams(newExtParams);
        int rowCount = this.inlongGroupMapper.updateByIdentifierSelective(oldGroup);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("inlong group has already updated with group id={}, curVersion={}", (Object)oldGroup.getInlongGroupId(), (Object)oldGroup.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        HashMap clusterMap = new HashMap();
        ClusterPageRequest clusterRequest = new ClusterPageRequest();
        List clusters = this.clusterMapper.selectByCondition(clusterRequest);
        clusters.forEach(v -> clusterMap.put(v.getName(), v));
        SinkPageRequest request = new SinkPageRequest();
        request.setInlongGroupId(inlongGroupId);
        List streamSinks = this.streamSinkMapper.selectByCondition(request);
        ArrayList<StreamSinkEntity> deleteStreamSinks = new ArrayList<StreamSinkEntity>();
        for (StreamSinkEntity streamSink : streamSinks) {
            String clusterName = streamSink.getInlongClusterName();
            InlongClusterEntity cluster = (InlongClusterEntity)clusterMap.get(clusterName);
            if (cluster == null || !StringUtils.equals((CharSequence)oldClusterTag, (CharSequence)cluster.getClusterTags())) continue;
            deleteStreamSinks.add(streamSink);
        }
        deleteStreamSinks.forEach(v -> this.streamSinkMapper.deleteById(v.getId()));
        return inlongGroupId;
    }
}

