/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.node.DataNodeOperator;
import org.apache.inlong.manager.service.node.DataNodeOperatorFactory;
import org.apache.inlong.manager.service.node.DataNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private DataNodeEntityMapper dataNodeMapper;
    @Autowired
    private DataNodeOperatorFactory operatorFactory;

    @Override
    public Integer save(DataNodeRequest request, String operator) {
        String type;
        DataNodeEntity existEntity;
        String name = request.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = UUID.randomUUID().toString();
            request.setName(name);
        }
        if ((existEntity = this.dataNodeMapper.selectByUniqueKey(name, type = request.getType())) != null) {
            String errMsg = String.format("data node already exist for name=%s type=%s)", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        int id = dataNodeOperator.saveOpt(request, operator);
        LOGGER.debug("success to save data node={}", (Object)request);
        return id;
    }

    @Override
    public Integer save(DataNodeRequest request, UserInfo opInfo) {
        DataNodeEntity existEntity;
        String name = request.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = UUID.randomUUID().toString();
            request.setName(name);
        }
        if ((existEntity = this.dataNodeMapper.selectByUniqueKey(request.getName(), request.getType())) != null) {
            throw new BusinessException(ErrorCodeEnum.RECORD_DUPLICATE, String.format("data node already exist for name=%s type=%s", request.getName(), request.getType()));
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        return dataNodeOperator.saveOpt(request, opInfo.getName());
    }

    @Override
    public DataNodeInfo get(Integer id, String currentUser) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("data node not found by id={}", (Object)id);
            throw new BusinessException("data node not found");
        }
        String dataNodeType = entity.getType();
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(dataNodeType);
        DataNodeInfo dataNodeInfo = dataNodeOperator.getFromEntity(entity);
        LOGGER.debug("success to get data node info by id={}", (Object)id);
        return dataNodeInfo;
    }

    @Override
    public DataNodeInfo get(Integer id, UserInfo opInfo) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(entity.getType());
        return dataNodeOperator.getFromEntity(entity);
    }

    @Override
    public DataNodeInfo get(String name, String type) {
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        if (entity == null) {
            String errMsg = String.format("data node not found by name=%s, type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(type);
        DataNodeInfo dataNodeInfo = dataNodeOperator.getFromEntity(entity);
        LOGGER.debug("success to get data node by name={} type={}", (Object)name, (Object)type);
        return dataNodeInfo;
    }

    @Override
    public PageResult<DataNodeInfo> list(DataNodePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dataNodeMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(entity.getType());
            return dataNodeOperator.getFromEntity((DataNodeEntity)entity);
        });
        LOGGER.debug("success to list data node by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<DataNodeInfo> list(DataNodePageRequest request, UserInfo opInfo) {
        request.setCurrentUser(opInfo.getName());
        request.setIsAdminRole(Boolean.valueOf(opInfo.getRoles().contains(TenantUserTypeEnum.TENANT_ADMIN.name())));
        List nodeEntities = this.dataNodeMapper.selectByCondition(request);
        return nodeEntities.stream().map(entity -> {
            DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(entity.getType());
            return dataNodeOperator.getFromEntity((DataNodeEntity)entity);
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(DataNodeRequest request, String operator) {
        LOGGER.info("begin to update data node by id: {}", (Object)request);
        DataNodeEntity curEntity = this.dataNodeMapper.selectById(request.getId());
        if (curEntity == null) {
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, String.format("data node record not found by id=%d", request.getId()));
        }
        this.chkUnmodifiableParams(curEntity, request);
        DataNodeEntity oldEntity = (DataNodeEntity)CommonBeanUtils.copyProperties((Object)curEntity, DataNodeEntity::new);
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        dataNodeOperator.updateOpt(request, operator);
        dataNodeOperator.updateRelatedStreamSource(request, oldEntity, operator);
        LOGGER.info("success to update data node={}", (Object)request);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(DataNodeRequest request, UserInfo opInfo) {
        String operator = opInfo.getName();
        return this.update(request, operator);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public UpdateResult updateByKey(DataNodeRequest request, String operator) {
        LOGGER.info("begin to update data node by key: {}", (Object)request);
        String name = request.getName();
        String type = request.getType();
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        if (entity == null) {
            String errMsg = String.format("data node not found by name=%s, type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        request.setId(entity.getId());
        Boolean result = this.update(request, operator);
        LOGGER.info("success to update data node by key: {}", (Object)request);
        return new UpdateResult(entity.getId(), result, Integer.valueOf(request.getVersion() + 1));
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.DATA_NODE_NOT_FOUND, (String)ErrorCodeEnum.DATA_NODE_NOT_FOUND.getMessage());
        return this.delete(entity, operator);
    }

    @Override
    public Boolean delete(Integer id, UserInfo opInfo) {
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.DATA_NODE_NOT_FOUND, (String)ErrorCodeEnum.DATA_NODE_NOT_FOUND.getMessage());
        entity.setIsDeleted(entity.getId());
        entity.setModifier(opInfo.getName());
        int rowCount = this.dataNodeMapper.updateById(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("data node has already updated, data node name=%s, type=%s, current version=%s", entity.getName(), entity.getType(), entity.getVersion()));
        }
        return true;
    }

    private Boolean delete(DataNodeEntity entity, String operator) {
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.dataNodeMapper.updateById(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("data node has already updated, data node name={}, type={}, current version ={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete data node by id={}, name={}", (Object)entity.getId(), (Object)entity.getName());
        return true;
    }

    private void chkUnmodifiableParams(DataNodeEntity curEntity, DataNodeRequest request) {
        Preconditions.expectEquals((Object)curEntity.getType(), (Object)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"type not allowed modify");
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            request.setName(curEntity.getName());
        } else {
            Preconditions.expectEquals((Object)curEntity.getName(), (Object)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"name not allowed modify");
        }
        Preconditions.expectEquals((Object)curEntity.getVersion(), (Object)request.getVersion(), (ErrorCodeEnum)ErrorCodeEnum.CONFIG_EXPIRED, (String)String.format("record has expired with record version=%d, request version=%d", curEntity.getVersion(), request.getVersion()));
    }

    @Override
    public Boolean deleteByKey(String name, String type, String operator) {
        DataNodeEntity entity = this.dataNodeMapper.selectByUniqueKey(name, type);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.DATA_NODE_NOT_FOUND, (String)ErrorCodeEnum.DATA_NODE_NOT_FOUND.getMessage());
        return this.delete(entity, operator);
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        LOGGER.info("begin test connection for: {}", (Object)request);
        String type = request.getType();
        DataNodeOperator dataNodeOperator = this.operatorFactory.getInstance(request.getType());
        Boolean result = dataNodeOperator.testConnection(request);
        LOGGER.info("connection [{}] for: {}", (Object)(result != false ? "success" : "failed"), (Object)request);
        return result;
    }
}

