/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.message;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.message.DeserializeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RawMsgDeserializeOperator
implements DeserializeOperator {
    private static final Logger log = LoggerFactory.getLogger(RawMsgDeserializeOperator.class);

    @Override
    public boolean accept(MessageWrapType type) {
        return MessageWrapType.RAW.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage> decodeMsg(InlongStreamInfo streamInfo, byte[] msgBytes, Map<String, String> headers, int index) {
        String groupId = headers.get("groupId");
        String streamId = headers.get("streamId");
        long msgTime = Long.parseLong(headers.getOrDefault("msgTime", "0"));
        return Collections.singletonList(new BriefMQMessage(Integer.valueOf(index), groupId, streamId, Long.valueOf(msgTime), headers.get("clientIp"), new String(msgBytes, Charset.forName(streamInfo.getDataEncoding()))));
    }
}

