/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sort;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperator;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperatorFactory;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortConfigListener.class);
    @Autowired
    private SortConfigOperatorFactory operatorFactory;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String className = processForm.getClass().getSimpleName();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof GroupResourceProcessForm || processForm instanceof StreamResourceProcessForm) {
            LOGGER.info("accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
            return true;
        }
        LOGGER.info("not accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
        return false;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        LOGGER.info("begin to build sort config for groupId={}", (Object)groupId);
        GroupOperateType operateType = form.getGroupOperateType();
        if (operateType == GroupOperateType.SUSPEND || operateType == GroupOperateType.DELETE) {
            LOGGER.info("no need to build sort config for groupId={} as the operate type is {}", (Object)groupId, (Object)operateType);
            return ListenerResult.success();
        }
        switch (operateType) {
            case INIT: {
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ING.getCode(), context.getOperator());
                break;
            }
            case RESTART: {
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ONLINE_ING.getCode(), context.getOperator());
            }
        }
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            String msg = "inlong group not found with groupId=" + groupId;
            LOGGER.error(msg);
            throw new WorkflowListenerException(msg);
        }
        form.setGroupInfo(groupInfo);
        form.setStreamInfos(this.streamService.list(groupId));
        List streamInfos = form.getStreamInfos();
        if (CollectionUtils.isEmpty((Collection)streamInfos)) {
            LOGGER.warn("no need to build sort config for groupId={}, as not found any stream", (Object)groupId);
            return ListenerResult.success();
        }
        int sinkCount = streamInfos.stream().map(stream -> stream.getSinkList() == null ? 0 : stream.getSinkList().size()).reduce(0, Integer::sum);
        if (sinkCount == 0) {
            LOGGER.warn("not build sort config for groupId={}, as not found any sink", (Object)groupId);
            return ListenerResult.success();
        }
        try {
            for (InlongStreamInfo streamInfo : streamInfos) {
                List sinkList = streamInfo.getSinkList();
                if (CollectionUtils.isEmpty((Collection)sinkList)) continue;
                List<String> sinkTypeList = sinkList.stream().map(StreamSink::getSinkType).collect(Collectors.toList());
                List<SortConfigOperator> operatorList = this.operatorFactory.getInstance(sinkTypeList);
                for (SortConfigOperator operator : operatorList) {
                    operator.buildConfig(groupInfo, streamInfo, InlongConstants.STANDARD_MODE.equals(groupInfo.getInlongGroupMode()));
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("failed to build sort config for groupId=%s, ", groupId);
            LOGGER.error(msg + "streamInfos=" + streamInfos, (Throwable)e);
            throw new WorkflowListenerException(msg + e.getMessage());
        }
        LOGGER.info("success to build sort config for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

