/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.apache.inlong.manager.service.cluster.InlongClusterOperatorFactory;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.elasticsearch.common.util.set.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractGroupOperator
implements InlongGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGroupOperator.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected InlongStreamService streamService;
    @Autowired
    protected InlongClusterService clusterService;
    @Autowired
    protected InlongGroupEntityMapper groupMapper;
    @Autowired
    protected InlongGroupExtEntityMapper groupExtMapper;
    @Autowired
    protected InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    protected InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    protected InlongClusterOperatorFactory clusterOperatorFactory;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String saveOpt(InlongGroupRequest request, String operator) {
        String groupId = request.getInlongGroupId();
        InlongGroupEntity entity = (InlongGroupEntity)CommonBeanUtils.copyProperties((Object)request, InlongGroupEntity::new);
        if (StringUtils.isEmpty((CharSequence)entity.getMqResource())) {
            entity.setMqResource(groupId);
        }
        this.setTargetEntity(request, entity);
        entity.setStatus(GroupStatus.TO_BE_SUBMIT.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.groupMapper.insert(entity);
        return groupId;
    }

    protected abstract void setTargetEntity(InlongGroupRequest var1, InlongGroupEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(InlongGroupRequest request, String operator) {
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(request.getInlongGroupId());
        CommonBeanUtils.copyProperties((Object)request, (Object)entity, (boolean)true);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        int rowCount = this.groupMapper.updateByIdentifierSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("record has already updated with group id=%s, curVersion=%d", request.getInlongGroupId(), request.getVersion()));
        }
    }

    @Override
    public Map<String, Object> getDetailInfo(InlongGroupInfo groupInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getClusterInfoByTag(groupInfo.getInlongClusterTag()));
        map.putIfAbsent(groupInfo.getMqType(), this.getMqInfo(groupInfo));
        return map;
    }

    @Override
    public Map<String, Object> getClusterInfoByTag(String clusterTag) {
        HashMap<String, Object> clusterMap = new HashMap<String, Object>();
        clusterMap.put("inlongClusterTag", clusterTag);
        HashSet mqClusters = Sets.newHashSet((Object[])new String[]{"PULSAR", "TUBEMQ", "KAFKA"});
        List clusterEntities = this.clusterEntityMapper.selectByClusterTag(clusterTag);
        for (InlongClusterEntity clusterEntity : clusterEntities) {
            if (mqClusters.contains(clusterEntity.getType())) continue;
            InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(clusterEntity.getType());
            clusterMap.putIfAbsent(clusterEntity.getType(), instance.getClusterInfo(clusterEntity));
        }
        return clusterMap;
    }

    @Override
    public Object getMqInfo(InlongGroupInfo groupInfo) {
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(groupInfo.getMqType());
        List clusterEntities = this.clusterEntityMapper.selectByKey(groupInfo.getInlongClusterTag(), null, groupInfo.getMqType());
        if (CollectionUtils.isEmpty((Collection)clusterEntities)) {
            return null;
        }
        ArrayList<Object> mqClusterInfo = new ArrayList<Object>();
        for (InlongClusterEntity clusterEntity : clusterEntities) {
            mqClusterInfo.add(instance.getClusterInfo(clusterEntity));
        }
        return mqClusterInfo;
    }
}

