/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="MongoExtract")
public class MongoExtractNode
extends ExtractNode
implements InlongMetric,
Metadata,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID = "_id";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="hostname")
    private String hosts;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="collection")
    private String collection;

    @JsonCreator
    public MongoExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField waterMarkField, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="collection") @Nonnull String collection, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="database") String database) {
        super(id, name, fields, waterMarkField, properties);
        if (fields.stream().noneMatch(m -> m.getName().equals(ID))) {
            ArrayList<FieldInfo> allFields = new ArrayList<FieldInfo>(fields);
            allFields.add(new FieldInfo(ID, (FormatInfo)new StringFormatInfo()));
            this.setFields(allFields);
        }
        this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"collection is null");
        this.hosts = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname is null");
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username is null");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password is null");
        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"database is null");
        this.primaryKey = ID;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "mongodb-cdc-inlong");
        options.put("hosts", this.hosts);
        options.put("username", this.username);
        options.put("password", this.password);
        options.put("database", this.database);
        options.put("collection", this.collection);
        return options;
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "table_name";
                break;
            }
            case COLLECTION_NAME: {
                metadataKey = "collection_name";
                break;
            }
            case SCHEMA_NAME: {
                metadataKey = "schema_name";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "database_name";
                break;
            }
            case OP_TS: {
                metadataKey = "op_ts";
                break;
            }
            case DATA_DEBEZIUM: 
            case DATA_BYTES_DEBEZIUM: {
                metadataKey = "meta.data_debezium";
                break;
            }
            case DATA_CANAL: 
            case DATA_BYTES_CANAL: {
                metadataKey = "meta.data_canal";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.COLLECTION_NAME, MetaField.DATABASE_NAME, MetaField.OP_TS, MetaField.DATA_DEBEZIUM, MetaField.DATA_BYTES_DEBEZIUM, MetaField.DATA_CANAL, MetaField.DATA_BYTES_CANAL});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoExtractNode)) {
            return false;
        }
        MongoExtractNode other = (MongoExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MongoExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        return result;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    @Override
    public String toString() {
        return "MongoExtractNode(primaryKey=" + this.getPrimaryKey() + ", hosts=" + this.getHosts() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ")";
    }
}

