/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.HudiConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="hudiExtract")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HudiExtractNode
extends ExtractNode
implements Serializable {
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="dbName")
    @Nonnull
    private String dbName;
    @JsonProperty(value="catalogType")
    private HudiConstant.CatalogType catalogType;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="warehouse")
    private String warehouse;
    @JsonProperty(value="readStreamingSkipCompaction")
    private boolean readStreamingSkipCompaction;
    @JsonProperty(value="readStartCommit")
    private String readStartCommit;
    @JsonProperty(value="extList")
    private List<HashMap<String, String>> extList;
    private static final long serialVersionUID = 1L;
    private int checkIntervalInMinus;

    public HudiExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="uri") String uri, @Nullable @JsonProperty(value="warehouse") String warehouse, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="catalogType") HudiConstant.CatalogType catalogType, @JsonProperty(value="checkIntervalInMinus") int checkIntervalInMinus, @JsonProperty(value="readStreamingSkipCompaction") boolean readStreamingSkipCompaction, @JsonProperty(value="readStartCommit") String readStartCommit, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="extList") List<HashMap<String, String>> extList) {
        super(id, name, fields, watermarkField, properties);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"table name is null");
        this.dbName = (String)Preconditions.checkNotNull((Object)dbName, (Object)"db name is null");
        this.catalogType = catalogType == null ? HudiConstant.CatalogType.HIVE : catalogType;
        this.uri = uri;
        this.warehouse = warehouse;
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
        this.readStartCommit = readStartCommit;
        this.extList = extList;
        this.checkIntervalInMinus = checkIntervalInMinus;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("read.streaming.enabled", "true");
        options.put("read.streaming.check-interval", String.valueOf(this.checkIntervalInMinus));
        options.put("hive_sync.enabled", "true");
        options.put("hive_sync.mode", "hms");
        options.put("hive_sync.db", this.dbName);
        options.put("hive_sync.table", this.tableName);
        options.put("hive_sync.metastore.uris", this.uri);
        if (CollectionUtils.isNotEmpty(this.extList)) {
            this.extList.forEach(ext -> {
                String keyName = (String)ext.get("keyName");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyName}) && keyName.startsWith("ddl.")) {
                    String ddlKeyName = keyName.substring("ddl.".length());
                    String ddlValue = (String)ext.get("keyValue");
                    options.put(ddlKeyName, ddlValue);
                }
            });
        }
        String path = String.format("%s/%s.db/%s", this.warehouse, this.dbName, this.tableName);
        options.put("path", path);
        options.put("read.start-commit", String.valueOf(this.readStreamingSkipCompaction));
        options.put("read.streaming.skip_compaction", this.readStartCommit);
        options.put("hoodie.database.name", this.dbName);
        options.put("hoodie.table.name", this.tableName);
        options.put("connector", "hudi-inlong");
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("hudi_table_%s", this.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiExtractNode)) {
            return false;
        }
        HudiExtractNode other = (HudiExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isReadStreamingSkipCompaction() != other.isReadStreamingSkipCompaction()) {
            return false;
        }
        if (this.getCheckIntervalInMinus() != other.getCheckIntervalInMinus()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        HudiConstant.CatalogType this$catalogType = this.getCatalogType();
        HudiConstant.CatalogType other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !((Object)((Object)this$catalogType)).equals((Object)other$catalogType)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$readStartCommit = this.getReadStartCommit();
        String other$readStartCommit = other.getReadStartCommit();
        if (this$readStartCommit == null ? other$readStartCommit != null : !this$readStartCommit.equals(other$readStartCommit)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        return !(this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HudiExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isReadStreamingSkipCompaction() ? 79 : 97);
        result = result * 59 + this.getCheckIntervalInMinus();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        HudiConstant.CatalogType $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : ((Object)((Object)$catalogType)).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $readStartCommit = this.getReadStartCommit();
        result = result * 59 + ($readStartCommit == null ? 43 : $readStartCommit.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        return result;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getDbName() {
        return this.dbName;
    }

    public HudiConstant.CatalogType getCatalogType() {
        return this.catalogType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public boolean isReadStreamingSkipCompaction() {
        return this.readStreamingSkipCompaction;
    }

    public String getReadStartCommit() {
        return this.readStartCommit;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public int getCheckIntervalInMinus() {
        return this.checkIntervalInMinus;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setDbName(@Nonnull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.dbName = dbName;
    }

    public void setCatalogType(HudiConstant.CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setReadStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
    }

    public void setReadStartCommit(String readStartCommit) {
        this.readStartCommit = readStartCommit;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public void setCheckIntervalInMinus(int checkIntervalInMinus) {
        this.checkIntervalInMinus = checkIntervalInMinus;
    }

    @Override
    public String toString() {
        return "HudiExtractNode(tableName=" + this.getTableName() + ", dbName=" + this.getDbName() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", readStreamingSkipCompaction=" + this.isReadStreamingSkipCompaction() + ", readStartCommit=" + this.getReadStartCommit() + ", extList=" + this.getExtList() + ", checkIntervalInMinus=" + this.getCheckIntervalInMinus() + ")";
    }
}

