/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.fieldtype;

import com.google.common.collect.Maps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class FieldTypeMappingReader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FieldTypeMappingReader.class);
    private static final String FILE_TYPE_MAPPING_CONVERTER_TEMPLATE_NAME = "%s-field-type-mapping.yaml";
    private static final String SOURCE_TO_TARGET_KEY = "source.type.to.target.type.converter";
    private static final String MAPPING_SOURCE_TYPE_KEY = "source.type";
    private static final String MAPPING_TARGET_TYPE_KEY = "target.type";
    protected final String streamType;
    protected final Map<String, String> FIELD_TYPE_MAPPING_MAP = Maps.newHashMap();

    public FieldTypeMappingReader(String streamType) {
        this.streamType = streamType;
        log.info("Field type mapping reader stream type:{}.", (Object)streamType);
        String converterMappingFileName = String.format(FILE_TYPE_MAPPING_CONVERTER_TEMPLATE_NAME, streamType.toLowerCase());
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(converterMappingFileName);
            if (Objects.isNull(resource)) {
                throw new IllegalArgumentException(String.format("Resource for the field type mapping converter %s not found in classpath.", converterMappingFileName));
            }
            Yaml yamlReader = new Yaml();
            Map converterConf = (Map)yamlReader.loadAs((Reader)new InputStreamReader(resource.openStream()), Map.class);
            this.readerOption(converterConf, SOURCE_TO_TARGET_KEY, this.FIELD_TYPE_MAPPING_MAP);
        }
        catch (Exception e) {
            log.error("Yaml reader read option error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void readerOption(Map<?, ?> converterConf, String key, Map<String, String> typeMapping) {
        if (converterConf.containsKey(key)) {
            List typeMappings = (List)converterConf.get(key);
            for (Map mapping : typeMappings) {
                String sourceType = (String)mapping.get(MAPPING_SOURCE_TYPE_KEY);
                String targetType = (String)mapping.get(MAPPING_TARGET_TYPE_KEY);
                if (StringUtils.isBlank((CharSequence)sourceType) || StringUtils.isBlank((CharSequence)targetType)) {
                    throw new IllegalArgumentException(String.format("Reader source type: %s, target type: %s are not valid.", sourceType, targetType));
                }
                typeMapping.put(sourceType, targetType);
            }
        } else {
            log.warn("Converter field type mapping conf can't find key: {} in converter file type {}.", (Object)key, (Object)this.streamType);
        }
    }

    public String getStreamType() {
        return this.streamType;
    }

    public Map<String, String> getFIELD_TYPE_MAPPING_MAP() {
        return this.FIELD_TYPE_MAPPING_MAP;
    }
}

