/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterOperator;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.StreamingGlobalCommitterOperator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class StreamingGlobalCommitterOperatorFactory<CommT, GlobalCommT>
extends AbstractStreamingCommitterOperatorFactory<CommT, GlobalCommT> {
    private final Sink<?, CommT, ?, GlobalCommT> sink;

    public StreamingGlobalCommitterOperatorFactory(Sink<?, CommT, ?, GlobalCommT> sink) {
        this.sink = (Sink)Preconditions.checkNotNull(sink);
    }

    @Override
    AbstractStreamingCommitterOperator<CommT, GlobalCommT> createStreamingCommitterOperator() {
        try {
            return new StreamingGlobalCommitterOperator((GlobalCommitter)this.sink.createGlobalCommitter().orElseThrow(() -> new IllegalStateException("Could not create global committer from the sink")), (SimpleVersionedSerializer)this.sink.getGlobalCommittableSerializer().orElseThrow(() -> new IllegalStateException("Could not create global committable serializer from the sink")));
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create the GlobalCommitter.", (Throwable)e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return StreamingGlobalCommitterOperator.class;
    }
}

