/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.LogicOperator;
import org.apache.inlong.sort.protocol.transformation.operator.EmptyOperator;

@JsonTypeName(value="betweenFunction")
public class BetweenFunction
implements FilterFunction {
    @Nonnull
    @JsonProperty(value="field")
    private final FunctionParam field;
    @Nonnull
    @JsonProperty(value="start")
    private final FunctionParam start;
    @Nonnull
    @JsonProperty(value="end")
    private final FunctionParam end;
    @Nonnull
    @JsonProperty(value="logicOperator")
    private final LogicOperator logicOperator;

    @JsonCreator
    public BetweenFunction(@Nonnull @JsonProperty(value="logicOperator") LogicOperator logicOperator, @Nonnull @JsonProperty(value="field") FunctionParam field, @Nonnull @JsonProperty(value="start") FunctionParam start, @Nonnull @JsonProperty(value="end") FunctionParam end) {
        this.field = Preconditions.checkNotNull(field, "field is null");
        this.start = Preconditions.checkNotNull(start, "start is null");
        this.end = Preconditions.checkNotNull(end, "end is null");
        this.logicOperator = Preconditions.checkNotNull(logicOperator, "logicOperator is null");
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.logicOperator, this.field, this.start, this.end);
    }

    @Override
    public String getName() {
        return "BETWEEN";
    }

    @Override
    public String format() {
        String format = "%s %s %s %s AND %s";
        if (this.logicOperator == EmptyOperator.getInstance()) {
            format = "%s%s %s %s AND %s";
        }
        return String.format(format, this.logicOperator.format(), this.field.format(), this.getName(), this.start.format(), this.end.format());
    }

    @Nonnull
    public FunctionParam getField() {
        return this.field;
    }

    @Nonnull
    public FunctionParam getStart() {
        return this.start;
    }

    @Nonnull
    public FunctionParam getEnd() {
        return this.end;
    }

    @Nonnull
    public LogicOperator getLogicOperator() {
        return this.logicOperator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenFunction)) {
            return false;
        }
        BetweenFunction other = (BetweenFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionParam this$field = this.getField();
        FunctionParam other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        FunctionParam this$start = this.getStart();
        FunctionParam other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        FunctionParam this$end = this.getEnd();
        FunctionParam other$end = other.getEnd();
        if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
            return false;
        }
        LogicOperator this$logicOperator = this.getLogicOperator();
        LogicOperator other$logicOperator = other.getLogicOperator();
        return !(this$logicOperator == null ? other$logicOperator != null : !this$logicOperator.equals(other$logicOperator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BetweenFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionParam $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        FunctionParam $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        FunctionParam $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        LogicOperator $logicOperator = this.getLogicOperator();
        result = result * 59 + ($logicOperator == null ? 43 : $logicOperator.hashCode());
        return result;
    }

    public String toString() {
        return "BetweenFunction(field=" + this.getField() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", logicOperator=" + this.getLogicOperator() + ")";
    }
}

