/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.enums.SchemaChangePolicy;
import org.apache.inlong.sort.protocol.enums.SchemaChangeType;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="icebergLoad")
public class IcebergLoadNode
extends LoadNode
implements InlongMetric,
Metadata,
Serializable {
    private static final long serialVersionUID = -1L;
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="dbName")
    @Nonnull
    private String dbName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="catalogType")
    private IcebergConstant.CatalogType catalogType;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="warehouse")
    private String warehouse;
    @JsonProperty(value="appendMode")
    private String appendMode;
    @Nullable
    @JsonProperty(value="sinkMultipleEnable")
    private Boolean sinkMultipleEnable = false;
    @Nullable
    @JsonProperty(value="sinkMultipleFormat")
    private Format sinkMultipleFormat;
    @Nullable
    @JsonProperty(value="databasePattern")
    private String databasePattern;
    @Nullable
    @JsonProperty(value="tablePattern")
    private String tablePattern;
    @Nullable
    @JsonProperty(value="enableSchemaChange")
    private boolean enableSchemaChange;
    @Nullable
    @JsonProperty(value="policyMap")
    private Map<SchemaChangeType, SchemaChangePolicy> policyMap;

    public IcebergLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="catalogType") IcebergConstant.CatalogType catalogType, @JsonProperty(value="uri") String uri, @JsonProperty(value="warehouse") String warehouse, @JsonProperty(value="appendMode") String appendMode) {
        this(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties, dbName, tableName, primaryKey, catalogType, uri, warehouse, appendMode, false, null, null, null, false, null);
    }

    @JsonCreator
    public IcebergLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="catalogType") IcebergConstant.CatalogType catalogType, @JsonProperty(value="uri") String uri, @JsonProperty(value="warehouse") String warehouse, @JsonProperty(value="appendMode") String appendMode, @Nullable @JsonProperty(value="sinkMultipleEnable", defaultValue="false") Boolean sinkMultipleEnable, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="databasePattern") String databasePattern, @Nullable @JsonProperty(value="tablePattern") String tablePattern, @JsonProperty(value="enableSchemaChange") boolean enableSchemaChange, @Nullable @JsonProperty(value="policyMap") Map<SchemaChangeType, SchemaChangePolicy> policyMap) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.primaryKey = primaryKey;
        this.catalogType = catalogType == null ? IcebergConstant.CatalogType.HIVE : catalogType;
        this.uri = uri;
        this.warehouse = warehouse;
        this.appendMode = appendMode;
        this.sinkMultipleEnable = sinkMultipleEnable;
        if (sinkMultipleEnable == null || !sinkMultipleEnable.booleanValue()) {
            this.tableName = Preconditions.checkNotNull(tableName, "table name is null");
            this.dbName = Preconditions.checkNotNull(dbName, "db name is null");
        } else {
            this.databasePattern = Preconditions.checkNotNull(databasePattern, "databasePattern is null");
            this.tablePattern = Preconditions.checkNotNull(tablePattern, "tablePattern is null");
            this.sinkMultipleFormat = Preconditions.checkNotNull(sinkMultipleFormat, "sinkMultipleFormat is null");
        }
        this.enableSchemaChange = enableSchemaChange;
        this.policyMap = policyMap;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "iceberg-inlong");
        options.put("catalog-database", this.dbName);
        options.put("catalog-table", this.tableName);
        options.put("default-database", this.dbName);
        options.put("catalog-type", this.catalogType.name());
        options.put("catalog-name", this.catalogType.name());
        if ("upsert".equals(this.appendMode)) {
            options.put("upsert-enabled", Boolean.TRUE.toString());
        } else {
            options.put("upsert-enabled", Boolean.FALSE.toString());
        }
        if (null != this.uri) {
            options.put("uri", this.uri);
        }
        if (null != this.warehouse) {
            options.put("warehouse", this.warehouse);
        }
        if (this.sinkMultipleEnable != null && this.sinkMultipleEnable.booleanValue()) {
            options.put("sink.multiple.enable", this.sinkMultipleEnable.toString());
            options.put("sink.multiple.format", Objects.requireNonNull(this.sinkMultipleFormat).identifier());
            options.put("sink.multiple.database-pattern", this.databasePattern);
            options.put("sink.multiple.table-pattern", this.tablePattern);
        } else {
            options.put("sink.multiple.enable", Boolean.FALSE.toString());
        }
        return options;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case AUDIT_DATA_TIME: {
                metadataKey = "audit_data_time";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", new Object[]{this.getClass().getSimpleName(), metaField}));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return false;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.AUDIT_DATA_TIME);
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getDbName() {
        return this.dbName;
    }

    public IcebergConstant.CatalogType getCatalogType() {
        return this.catalogType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getAppendMode() {
        return this.appendMode;
    }

    @Nullable
    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    @Nullable
    public Format getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    @Nullable
    public String getDatabasePattern() {
        return this.databasePattern;
    }

    @Nullable
    public String getTablePattern() {
        return this.tablePattern;
    }

    @Nullable
    public boolean isEnableSchemaChange() {
        return this.enableSchemaChange;
    }

    @Nullable
    public Map<SchemaChangeType, SchemaChangePolicy> getPolicyMap() {
        return this.policyMap;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setDbName(@Nonnull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.dbName = dbName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setCatalogType(IcebergConstant.CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setAppendMode(String appendMode) {
        this.appendMode = appendMode;
    }

    public void setSinkMultipleEnable(@Nullable Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(@Nullable Format sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(@Nullable String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(@Nullable String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setEnableSchemaChange(@Nullable boolean enableSchemaChange) {
        this.enableSchemaChange = enableSchemaChange;
    }

    public void setPolicyMap(@Nullable Map<SchemaChangeType, SchemaChangePolicy> policyMap) {
        this.policyMap = policyMap;
    }

    @Override
    public String toString() {
        return "IcebergLoadNode(tableName=" + this.getTableName() + ", dbName=" + this.getDbName() + ", primaryKey=" + this.getPrimaryKey() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", appendMode=" + this.getAppendMode() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", enableSchemaChange=" + this.isEnableSchemaChange() + ", policyMap=" + this.getPolicyMap() + ")";
    }

    public IcebergLoadNode() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergLoadNode)) {
            return false;
        }
        IcebergLoadNode other = (IcebergLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnableSchemaChange() != other.isEnableSchemaChange()) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        IcebergConstant.CatalogType this$catalogType = this.getCatalogType();
        IcebergConstant.CatalogType other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !((Object)((Object)this$catalogType)).equals((Object)other$catalogType)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$appendMode = this.getAppendMode();
        String other$appendMode = other.getAppendMode();
        if (this$appendMode == null ? other$appendMode != null : !this$appendMode.equals(other$appendMode)) {
            return false;
        }
        Format this$sinkMultipleFormat = this.getSinkMultipleFormat();
        Format other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        Map<SchemaChangeType, SchemaChangePolicy> this$policyMap = this.getPolicyMap();
        Map<SchemaChangeType, SchemaChangePolicy> other$policyMap = other.getPolicyMap();
        return !(this$policyMap == null ? other$policyMap != null : !((Object)this$policyMap).equals(other$policyMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnableSchemaChange() ? 79 : 97);
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        IcebergConstant.CatalogType $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : ((Object)((Object)$catalogType)).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $appendMode = this.getAppendMode();
        result = result * 59 + ($appendMode == null ? 43 : $appendMode.hashCode());
        Format $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        Map<SchemaChangeType, SchemaChangePolicy> $policyMap = this.getPolicyMap();
        result = result * 59 + ($policyMap == null ? 43 : ((Object)$policyMap).hashCode());
        return result;
    }
}

