/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.util.StringUtils;

public final class KvDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;

    public KvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this.rowFormatInfo = rowFormatInfo;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.charset = charset;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public KvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf('&'), Character.valueOf('='), null, null, null);
    }

    public TypeInformation<Row> getProducedType() {
        return TableFormatUtils.getType(this.rowFormatInfo.getTypeInfo());
    }

    public boolean isEndOfStream(Row row) {
        return false;
    }

    public Row deserialize(byte[] bytes) throws IOException {
        String text = new String(bytes, Charset.forName(this.charset));
        Map<String, String> fieldTexts = StringUtils.splitKv(text, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar);
        String[] fieldNames = this.rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
        Row row = new Row(fieldFormatInfos.length);
        for (int i = 0; i < fieldFormatInfos.length; ++i) {
            String fieldName = fieldNames[i];
            FormatInfo fieldFormatInfo = fieldFormatInfos[i];
            String fieldText = fieldTexts.get(fieldName);
            Object field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, this.nullLiteral);
            row.setField(i, field);
        }
        return row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvDeserializationSchema that = (KvDeserializationSchema)o;
        return this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.entryDelimiter, that.entryDelimiter) && Objects.equals(this.kvDelimiter, that.kvDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder {
        private final RowFormatInfo rowFormatInfo;
        private String charset = "UTF-8";
        private char entryDelimiter = (char)38;
        private char kvDelimiter = (char)61;
        private Character escapeChar = null;
        private Character quoteChar = null;
        private String nullLiteral = null;

        public Builder(RowFormatInfo rowFormatInfo) {
            this.rowFormatInfo = rowFormatInfo;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setEntryDelimiter(char delimiter) {
            this.entryDelimiter = delimiter;
            return this;
        }

        public Builder setKvDelimiter(char delimiter) {
            this.kvDelimiter = delimiter;
            return this;
        }

        public Builder setEscapeCharacter(char escapeChar) {
            this.escapeChar = Character.valueOf(escapeChar);
            return this;
        }

        public Builder setQuoteCharacter(char quoteChar) {
            this.quoteChar = Character.valueOf(quoteChar);
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            this.nullLiteral = nullLiteral;
            return this;
        }

        public KvDeserializationSchema build() {
            return new KvDeserializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.entryDelimiter), Character.valueOf(this.kvDelimiter), this.escapeChar, this.quoteChar, this.nullLiteral);
        }
    }
}

