/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgCsvUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InLongMsgUtils.class);
    public static final String FORMAT_DELETE_HEAD_DELIMITER = "format.delete-head-delimiter";
    public static final boolean DEFAULT_DELETE_HEAD_DELIMITER = true;

    public static InLongMsgBody parseBody(byte[] bytes, String charset, char delimiter, Character escapeChar, Character quoteChar, boolean deleteHeadDelimiter) {
        String bodyText = bytes[0] == delimiter && deleteHeadDelimiter ? new String(bytes, 1, bytes.length - 1, Charset.forName(charset)) : new String(bytes, Charset.forName(charset));
        String[] fieldTexts = StringUtils.splitCsv(bodyText, Character.valueOf(delimiter), escapeChar, quoteChar);
        return new InLongMsgBody(bytes, null, Arrays.asList(fieldTexts), Collections.emptyMap());
    }

    public static Row buildRow(RowFormatInfo rowFormatInfo, String nullLiteral, Timestamp time, Map<String, String> attributes, List<String> predefinedFields, List<String> fields) {
        Object field;
        String fieldText;
        FormatInfo fieldFormatInfo;
        String fieldName;
        int i;
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        int actualNumFields = predefinedFields.size() + fields.size();
        if (actualNumFields != fieldNames.length) {
            LOG.warn("The number of fields mismatches: " + fieldNames.length + " expected, but was " + actualNumFields + ".");
        }
        Row row = new Row(2 + fieldNames.length);
        row.setField(0, (Object)time);
        row.setField(1, attributes);
        for (i = 0; i < predefinedFields.size() && i < fieldNames.length; ++i) {
            fieldName = fieldNames[i];
            fieldFormatInfo = fieldFormatInfos[i];
            fieldText = predefinedFields.get(i);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral);
            row.setField(i + 2, field);
        }
        for (i = 0; i < fields.size() && i + predefinedFields.size() < fieldNames.length; ++i) {
            fieldName = fieldNames[i + predefinedFields.size()];
            fieldFormatInfo = fieldFormatInfos[i + predefinedFields.size()];
            fieldText = fields.get(i);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral);
            row.setField(i + predefinedFields.size() + 2, field);
        }
        for (i = predefinedFields.size() + fields.size(); i < fieldNames.length; ++i) {
            row.setField(i + 2, null);
        }
        return row;
    }
}

