/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.inlongmsg.AbstractInLongMsgMixedFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvUtils;

public final class InLongMsgCsvMixedFormatDeserializer
extends AbstractInLongMsgMixedFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final Character delimiter;
    @Nonnull
    private final String charset;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    private final boolean deleteHeadDelimiter;

    public InLongMsgCsvMixedFormatDeserializer(@Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, boolean deleteHeadDelimiter, boolean ignoreErrors) {
        super(ignoreErrors);
        this.delimiter = delimiter;
        this.charset = charset;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.deleteHeadDelimiter = deleteHeadDelimiter;
    }

    public InLongMsgCsvMixedFormatDeserializer() {
        this("UTF-8", Character.valueOf(','), null, null, true, false);
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.MIXED_ROW_TYPE;
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgUtils.parseHead(attr);
    }

    @Override
    protected InLongMsgBody parseBody(byte[] bytes) {
        return InLongMsgCsvUtils.parseBody(bytes, this.charset, this.delimiter.charValue(), this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }

    @Override
    protected Row convertRow(InLongMsgHead head, InLongMsgBody body) {
        return InLongMsgUtils.buildMixedRow(head, body, head.getTid());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InLongMsgCsvMixedFormatDeserializer that = (InLongMsgCsvMixedFormatDeserializer)o;
        return this.deleteHeadDelimiter == that.deleteHeadDelimiter && this.charset.equals(that.charset) && this.delimiter.equals(that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }
}

