/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgMixedFormatConverter;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgCsvMixedFormatConverter
implements InLongMsgMixedFormatConverter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(InLongMsgCsvMixedFormatConverter.class);
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String timeFieldName;
    @Nonnull
    private final String attributesFieldName;
    private final String nullLiteral;
    private final boolean ignoreErrors;

    public InLongMsgCsvMixedFormatConverter(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String timeFieldName, @Nonnull String attributesFieldName, String nullLiteral, boolean ignoreErrors) {
        this.rowFormatInfo = rowFormatInfo;
        this.timeFieldName = timeFieldName;
        this.attributesFieldName = attributesFieldName;
        this.nullLiteral = nullLiteral;
        this.ignoreErrors = ignoreErrors;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.buildRowType(this.timeFieldName, this.attributesFieldName, this.rowFormatInfo);
    }

    public void flatMap(Row mixedRow, Collector<Row> collector) {
        Row row;
        try {
            Timestamp time = InLongMsgUtils.getTimeFromMixedRow(mixedRow);
            Map<String, String> attributes = InLongMsgUtils.getAttributesFromMixedRow(mixedRow);
            List<String> predefinedFields = InLongMsgUtils.getPredefinedFieldsFromMixedRow(mixedRow);
            List<String> fields = InLongMsgUtils.getFieldsFromMixedRow(mixedRow);
            row = InLongMsgCsvUtils.buildRow(this.rowFormatInfo, this.nullLiteral, time, attributes, predefinedFields, fields);
        }
        catch (Exception e) {
            if (this.ignoreErrors) {
                LOG.warn("Cannot properly convert the mixed row {} to row.", (Object)mixedRow, (Object)e);
                return;
            }
            throw e;
        }
        collector.collect((Object)row);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InLongMsgCsvMixedFormatConverter that = (InLongMsgCsvMixedFormatConverter)o;
        return this.ignoreErrors == that.ignoreErrors && this.rowFormatInfo.equals(that.rowFormatInfo) && this.timeFieldName.equals(that.timeFieldName) && this.attributesFieldName.equals(that.attributesFieldName) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.nullLiteral, this.ignoreErrors);
    }
}

