/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;

public class Csv
implements Descriptor {
    public static final String FORMAT_TYPE_VALUE = "tdcsv";
    private final String type;
    private final int version;
    private DescriptorProperties internalProperties = new DescriptorProperties(true);

    public Csv() {
        this.type = FORMAT_TYPE_VALUE;
        this.version = 1;
    }

    public Csv delimiter(char delimiter) {
        this.internalProperties.putCharacter("format.delimiter", delimiter);
        return this;
    }

    public Csv escapeCharacter(char escapeCharacter) {
        this.internalProperties.putCharacter("format.escape-character", escapeCharacter);
        return this;
    }

    public Csv quoteCharacter(char quoteCharacter) {
        this.internalProperties.putCharacter("format.quote-character", quoteCharacter);
        return this;
    }

    public Csv nullLiteral(String nullLiteral) {
        Preconditions.checkNotNull((Object)nullLiteral);
        this.internalProperties.putString("format.null-literal", nullLiteral);
        return this;
    }

    public Csv charset(Charset charset) {
        Preconditions.checkNotNull((Object)charset);
        this.internalProperties.putString("format.charset", charset.name());
        return this;
    }

    public Csv ignoreErrors() {
        this.internalProperties.putBoolean("format.ignore-errors", true);
        return this;
    }

    public Csv schema(String schema) {
        Preconditions.checkNotNull((Object)schema);
        this.internalProperties.putString("format.schema", schema);
        return this;
    }

    public Csv deriveSchema() {
        this.internalProperties.putBoolean("format.derive-schema", true);
        return this;
    }

    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("format.type", this.type);
        properties.putInt("format.property-version", this.version);
        properties.putProperties(this.toFormatProperties());
        return properties.asMap();
    }

    protected Map<String, String> toFormatProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(this.internalProperties);
        return properties.asMap();
    }
}

