/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.common;

import java.nio.charset.StandardCharsets;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.formats.common.BasicFormatInfo;
import org.apache.inlong.sort.formats.common.TypeInfo;
import org.apache.inlong.sort.formats.common.VarBinaryTypeInfo;

public class VarBinaryFormatInfo
implements BasicFormatInfo<byte[]> {
    private static final long serialVersionUID = 1L;
    public static final VarBinaryFormatInfo INSTANCE = new VarBinaryFormatInfo();
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = Integer.MAX_VALUE;
    @JsonProperty(value="length")
    private int length;

    public VarBinaryFormatInfo() {
        this(Integer.MAX_VALUE);
    }

    @JsonCreator
    public VarBinaryFormatInfo(@JsonProperty(value="length") int length) {
        if (length < 1) {
            throw new IllegalArgumentException(String.format("VarBinary string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    @Override
    public String serialize(byte[] record) throws Exception {
        return new String(record, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] deserialize(String text) throws Exception {
        return text.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return VarBinaryTypeInfo.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

